package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.table.TableModel;

import ohd.hseb.hefs.utils.gui.jtable.GenericTable;

/**
 * If a table model requires its data to be editored or rendered using non-default tools (see {@link GenericTable}) then
 * it must implement this interface. Those renderers can be setup multiple times throughout the life of a table due to
 * the fact that {@link GenericTable}'s reset method may be called whenever the table's underlying data model changes.
 * Hence, it is not enough to construct the {@link GenericTable} and call its setDefault methods.
 * 
 * @author hankherr
 */
public interface DefaultEditorsAndRenderersOverrideTableModel extends TableModel, TableAwareTableModel
{

    /**
     * Setup editors and renderers to override the default settings in {@link GenericTable}. See {@link GenericTable}.
     */
    public void setupOverrideEditorsAndRenderers();
}
