package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

/**
 * {@link TableModel} which forwards all its method calls to an underlying delegate {@link TableModel}. Override
 * {@link #getDelegate()} to specify the underlying model.
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public abstract class ForwardingTableModel<E> extends AbstractTableModel implements ToolTipTableModel,
AddDeleteRowTableModel, PreferredWidthsTableModel, MaxWidthsTableModel, MinWidthsTableModel, TableAwareTableModel,
SelectionMaintainingTableModel<E>, GetRowTableModel<E>, RefreshTableModel
{

    public abstract TableModel getDelegate();

    @Override
    public int getRowCount()
    {
        return getDelegate().getRowCount();
    }

    @Override
    public int getColumnCount()
    {
        return getDelegate().getColumnCount();
    }

    @Override
    public String getColumnName(final int columnIndex)
    {
        return getDelegate().getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(final int columnIndex)
    {
        return getDelegate().getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(final int rowIndex, final int columnIndex)
    {
        return getDelegate().isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public Object getValueAt(final int rowIndex, final int columnIndex)
    {
        return getDelegate().getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(final Object aValue, final int rowIndex, final int columnIndex)
    {
        getDelegate().setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public void addTableModelListener(final TableModelListener l)
    {
        getDelegate().addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(final TableModelListener l)
    {
        getDelegate().removeTableModelListener(l);
    }

    @Override
    public String getColumnHeaderToolTip(final int modelColIndex)
    {
        if(getDelegate() instanceof ToolTipTableModel)
        {
            return ((ToolTipTableModel)getDelegate()).getColumnHeaderToolTip(modelColIndex);
        }
        else
        {
            return "";
        }
    }

    @Override
    public String getCellToolTip(final int modelRowIndex, final int modelColIndex)
    {
        if(getDelegate() instanceof ToolTipTableModel)
        {
            return ((ToolTipTableModel)getDelegate()).getCellToolTip(modelRowIndex, modelColIndex);
        }
        else
        {
            return "";
        }
    }

    @Override
    public void addRow()
    {
        if(getDelegate() instanceof AddDeleteRowTableModel)
        {
            ((AddDeleteRowTableModel)getDelegate()).addRow();
        }
        else
        {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void deleteRow(final int indexOfRowClicked, final int[] allTableSelectedIndices)
    {
        if(getDelegate() instanceof AddDeleteRowTableModel)
        {
            ((AddDeleteRowTableModel)getDelegate()).deleteRow(indexOfRowClicked, allTableSelectedIndices);
        }
        else
        {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Integer getPreferredWidth(final int column)
    {
        if(getDelegate() instanceof PreferredWidthsTableModel)
        {
            return ((PreferredWidthsTableModel)getDelegate()).getPreferredWidth(column);
        }
        else
        {
            return null;
        }
    }

    @Override
    public Integer getMaxWidth(final int column)
    {
        if(getDelegate() instanceof MaxWidthsTableModel)
        {
            return ((MaxWidthsTableModel)getDelegate()).getMaxWidth(column);
        }
        else
        {
            return null;
        }
    }

    @Override
    public Integer getMinWidth(final int column)
    {
        if(getDelegate() instanceof MinWidthsTableModel)
        {
            return ((MinWidthsTableModel)getDelegate()).getMinWidth(column);
        }
        else
        {
            return null;
        }
    }

    @Override
    public void addTable(final JTable table)
    {
        final TableModel delegate = getDelegate();
        if(delegate instanceof TableAwareTableModel)
        {
            ((TableAwareTableModel)delegate).addTable(table);
        }
    }

    @Override
    public void removeTable(final JTable table)
    {
        final TableModel delegate = getDelegate();
        if(delegate instanceof TableAwareTableModel)
        {
            ((TableAwareTableModel)delegate).removeTable(table);
        }
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    @Override
    public E getRow(final int index)
    {
        final TableModel delegate = getDelegate();
        if(delegate instanceof GetRowTableModel)
        {
            return (E)((GetRowTableModel)delegate).getRow(index);
        }
        else
        {
            return null;
        }
    }

    @SuppressWarnings({"unchecked", "rawtypes"})
    @Override
    public int getRowIndex(final E row)
    {
        final TableModel delegate = getDelegate();
        if(delegate instanceof GetRowTableModel)
        {
            return ((GetRowTableModel)delegate).getRowIndex(row);
        }
        else
        {
            return -1;
        }
    }

    @Override
    public void refresh()
    {
        final TableModel delegate = getDelegate();
        if(delegate instanceof RefreshTableModel)
        {
            ((RefreshTableModel)delegate).refresh();
        }
    }
}
