package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.table.TableModel;

/**
 * Provides a way to retrieve a given row from this model as a single object.
 * 
 * @author alexander.garbarino
 * @param <E> the class which a row is returned as
 */
public interface GetRowTableModel<E> extends TableModel
{
    /**
     * @param index Row index according to the table model.
     * @return Returns the specified row as an Object.
     */
    public E getRow(int index);

    /**
     * @param row The row {@link Object}, returned by {@link #getRow(int)}.
     * @return The index of the row according to the model. A negative return indicates the row does not exist.
     */
    public int getRowIndex(E row);
}
