package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.table.TableModel;

/**
 * A table model which specifies a max width for each of its columns. Useful if the model knows the approximate size of
 * the data it is going to be displaying.
 * 
 * @author alexander.garbarino
 */
public interface MaxWidthsTableModel extends TableModel
{
    /**
     * Get this model's max width for a given column. Null is returned if there is no max width.
     * 
     * @param column the table column to get the width for
     * @return the max width, or null if there is none
     */
    public Integer getMaxWidth(int column);
}
