package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.table.TableModel;

/**
 * A table model which specifies a min width for each of its columns. Useful if the model knows the approximate size of
 * the data it is going to be displaying.
 * 
 * @author alexander.garbarino
 */
public interface MinWidthsTableModel extends TableModel
{
    /**
     * Get this model's min width for a given column. Null is returned if there is no min width.
     * 
     * @param column the table column to get the width for
     * @return the min width, or null if there is none
     */
    public Integer getMinWidth(int column);
}
