package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.table.TableModel;

/**
 * A table model which specifies a preferred width for each of its columns. Useful if the model knows the approximate
 * size of the data it is going to be displaying.
 * 
 * @author alexander.garbarino
 */
public interface PreferredWidthsTableModel extends TableModel
{
    /**
     * Get this model's preferred width for a given column. Null is returned if there is no preferred width.
     * 
     * @param column the table column to get the width for
     * @return the preferred width, or null if there is none
     */
    public Integer getPreferredWidth(int column);
}
