package ohd.hseb.hefs.utils.gui.jtable.models;

import ohd.hseb.hefs.utils.gui.jtable.TableTools;

/**
 * Interface for a table model that allows for rows to be checked. It allows for easy creation of buttons, via
 * {@link TableTools} methods, for checking rows. It does not automatically adjust the columns of the tables to include
 * a selected column or provide variables for storing the selection. It extends the {@link TableAwareTableModel}
 * interface, because its assumed that the model must be able to talk to the table in order to determine the selected
 * rows.
 * 
 * @author hankherr
 */
public interface RowCheckableTableModel extends TableAwareTableModel
{

    /**
     * Check the selected rows.
     */
    public void checkSelected();

    /**
     * Uncheck the selected rows;
     */
    public void uncheckSelected();

    /**
     * Check all rows.
     */
    public void checkAll();

    /**
     * Uncheck all rows.
     */
    public void uncheckAll();

}
