package ohd.hseb.hefs.utils.gui.jtable.models;

import java.awt.Color;

import javax.swing.table.TableModel;

import ohd.hseb.hefs.utils.Dyad;
import ohd.hseb.hefs.utils.gui.jtable.GenericTable;
import ohd.hseb.hefs.utils.gui.jtable.MarkedTableScrollPanel;

/**
 * This tells the {@link MarkedTableScrollPanel} which color to use for a mark on rows or columns. This type of model is
 * only useful within the {@link MarkedTableScrollPanel}; {@link GenericTable} does nothing with it.
 * 
 * @author hankherr
 */
public interface RowColumnMarkingTableModel extends TableModel
{

    /**
     * @param modelRow The model row index (NOT the view row index!).
     * @return The {@link Color} to use for a mark at the provided row, along with a priority level int returned in a
     *         {@link Dyad}. Low priority marks are drawn first, allowing more important marks a better chance of being
     *         seen.
     */
    public Dyad<Color, Integer> getRowMarkColor(int modelRow);

    /**
     * @param modelCol The model column index (NOT the view column index!).
     * @return The {@link Color} to use for a mark at the provided column, along with a priority level int returned in a
     *         {@link Dyad}. Low priority marks are drawn first, allowing more important marks a better chance of being
     *         seen.
     */
    public Dyad<Color, Integer> getColumnMarkColor(int modelCol);

}
