package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

import ohd.hseb.hefs.utils.gui.jtable.GenericTable;
import ohd.hseb.hefs.utils.gui.jtable.GenericTableRowHeaderViewport;
import ohd.hseb.hefs.utils.gui.jtable.MarkedTableScrollPanel;

/**
 * Used within a {@link GenericTableRowHeaderViewport} to determine if a header is needed. If implemented, then the
 * {@link GenericTable} should display a row header using the column returned by {@link #getRowHeaderColumn()}.
 * However, this only applies if the {@link JScrollPane} is able to handle it. For example,
 * {@link MarkedTableScrollPanel} can handle this interface.
 * 
 * @author hankherr
 */
public interface RowHeaderTableModel extends TableModel
{
    /**
     * @return The column to display as a row header column, or -1 if no column should currently be displayed.
     */
    public int getRowHeaderColumn();
}
