package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.JTable;
import javax.swing.table.TableModel;

/**
 * Table Model which can have access to the tables it is being displayed in.
 * 
 * @author alexander.garbarino
 */
public interface TableAwareTableModel extends TableModel
{
    /**
     * Adds a table to this model, letting it know it is displaying it.
     * 
     * @param table the table to add
     */
    public void addTable(JTable table);

    /**
     * Removes a table from this model, letting it know it is no longer being displayed.
     * 
     * @param table the table to remove
     */
    public void removeTable(JTable table);
}
