package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.JTable;
import javax.swing.table.TableModel;

/**
 * {@link TableModel} that specifies tool tips to display in a {@link JTable}.
 * 
 * @author Hank.Herr
 */
public interface ToolTipTableModel extends TableModel
{
    /**
     * @param modelColIndex May be negative, indicating no column is being hovered over.
     * @return Return a tool tip for the header.
     */
    public String getColumnHeaderToolTip(int modelColIndex);

    /**
     * @param modelRowIndex May be negative, indicating no row is being hovered over.
     * @param modelColIndex May be negative, indicating no column is being hovered over.
     * @return Return a tool tip for the cell.
     */
    public String getCellToolTip(int modelRowIndex, int modelColIndex);

}
