package ohd.hseb.hefs.utils.gui.jtable.models;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

import ohd.hseb.hefs.utils.gui.jtable.GenericTable;
import ohd.hseb.hefs.utils.gui.jtable.renderers.ColorByEditableTableCellRenderer;
import ohd.hseb.hefs.utils.gui.jtable.renderers.EmptyLabelOnNullOrNaNRenderer;
import ohd.hseb.hefs.utils.gui.jtable.renderers.ForwardingTableCellRenderer;

/**
 * Implement if a model should have a particular type of {@link TableCellRenderer} wrapping the default data type
 * specific renderers used by {@link JTable} and {@link GenericTable}.
 * 
 * @author hankherr
 */
public interface WrapRendererTableModel extends TableModel
{
    /**
     * @return If true, then this renderer is applied after all the other default renderers are applied. Otherwise, it
     *         replaces {@link ColorByEditableTableCellRenderer} in the order of renderer application, wrapping the
     *         default data type specific {@link JTable} renderers directly (the {@link EmptyLabelOnNullOrNaNRenderer} is
     *         then applied to this wrapped renderer). See {@link GenericTable} wrapRenderer method.
     */
    public boolean applyAfterAllOtherRenderers();

    /**
     * See {@link GenericTable} wrapRenderer method. If the {@link TableModel} it uses implements this interface,
     * {@link GenericTable} will pass the default renderers this renderer for wrapping. The new renderer will likely
     * need to be an instance of {@link ForwardingTableCellRenderer}, or a subclass, so that it first uses the passed in
     * renderer and then modifies the results.<br>
     * <br>
     * See {@link #applyAfterAllOtherRenderers()} for how it is appleid.
     * 
     * @param baseRenderer The renderer to wrap.
     * @return The wrapped renderer.
     */
    public TableCellRenderer wrapRenderer(TableCellRenderer baseRenderer);

}
