package ohd.hseb.hefs.utils.gui.jtable.renderers;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableCellRenderer;

/**
 * Modifies an existing {@link TableCellRenderer} to colors cells by whether or not they're editable. White is used for
 * editable, gray is used to not editable.
 * 
 * @author alexander.garbarino
 */
public class ColorByEditableTableCellRenderer extends ForwardingTableCellRenderer
{
    private final Color _edit;
    private final Color _noEdit;

    public ColorByEditableTableCellRenderer(TableCellRenderer delegate)
    {
        this(delegate, Color.WHITE, null);
    }

    public ColorByEditableTableCellRenderer(TableCellRenderer delegate, Color noEditColor)
    {
        this(delegate, Color.WHITE, noEditColor);
    }

    public ColorByEditableTableCellRenderer(TableCellRenderer delegate, Color editColor, Color noEditColor)
    {
        super(delegate);
        _edit = editColor;
        _noEdit = noEditColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column)
    {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        int modelRow;
        {
            RowSorter sorter = table.getRowSorter();
            if(sorter == null)
            {
                modelRow = row;
            }
            else
            {
                modelRow = sorter.convertRowIndexToModel(row);
            }
        }

        //There is a possibility that the column component is called for while the model is changing.  This avoids possible
        //problems due to that by not processing a portion of the code that could cause the problem.
        if(column <= table.getColumnModel().getColumnCount())
        {
            int modelColumn = table.getColumnModel().getColumn(column).getModelIndex();
            if(!isSelected)
            {
                if(_noEdit != null && !table.getModel().isCellEditable(modelRow, modelColumn))
                {
                    component.setBackground(_noEdit);
                }
                else
                {
                    component.setBackground(_edit);
                }
            }
        }

        return component;
    }
}
