package ohd.hseb.hefs.utils.gui.jtable.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

import ohd.hseb.hefs.utils.gui.components.AlphaColorChooserPanel;

/**
 * Editor to use to edit colors listed in a table. When editing, it opens up a a color chooser with an
 * AlphaColorChooserPanel addition (to modify transparency of color).
 * 
 * @author hank.herr
 */
public class ColorCellEditor extends AbstractCellEditor implements TableCellEditor, ActionListener
{
    private static final long serialVersionUID = 1L;

    Color _currentColor;
    JButton _button;
    JColorChooser _colorChooser;
    JDialog _dialog;
    protected static final String EDIT = "edit";

    public ColorCellEditor()
    {
        _button = new JButton();
        _button.setActionCommand(EDIT);
        _button.addActionListener(this);
        _button.setBorderPainted(false);

        //Set up the dialog that the button brings up.
        _colorChooser = new JColorChooser();

        _colorChooser.addChooserPanel(new AlphaColorChooserPanel(null));
        _dialog = JColorChooser.createDialog(_button, "Pick a Color", true, //modal
                                             _colorChooser,
                                             this, //OK button handler
                                             null); //no CANCEL button handler
    }

    @Override
    public void actionPerformed(ActionEvent e)
    {
        if(EDIT.equals(e.getActionCommand()))
        {
            //The user has clicked the cell, so
            //bring up the dialog.
            _button.setBackground(_currentColor);
            _colorChooser.setColor(_currentColor);
            _dialog.setVisible(true);

            fireEditingStopped(); //Make the renderer reappear.

        }
        else
        { //User pressed dialog's "OK" button.
            _currentColor = _colorChooser.getColor();
        }
    }

    @Override
    public Object getCellEditorValue()
    {
        return _currentColor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column)
    {
        _currentColor = (Color)value;
        return _button;
    }
}
