package ohd.hseb.hefs.utils.gui.jtable.renderers;

import java.awt.Color;
import java.awt.Component;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * This class is courtesy of http://java.sun.com/docs/books/tutorial/uiswing/components/table.html#editrender. It
 * displays a color within a table and may be used for cells which allow for selecting a color.
 * 
 * @author herrhd
 */
public class ColorCellRenderer extends JLabel implements TableCellRenderer
{
    private static final long serialVersionUID = 1L;

    private final boolean _isBordered;

    public ColorCellRenderer(boolean isBordered)
    {
        this._isBordered = isBordered;
        setOpaque(true); //MUST do this for background to show up.
    }

    @Override
    public Component getTableCellRendererComponent(JTable table,
                                                   Object color,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column)
    {
        Color newColor = (Color)color;
        setBackground(newColor);
        if(_isBordered)
        {
            if(isSelected)
            {
                setBorder(BorderFactory.createLineBorder(table.getSelectionBackground()));
            }
            else
            {

                setBorder(BorderFactory.createLineBorder(table.getBackground()));
            }
        }

        return this;
    }

}
