package ohd.hseb.hefs.utils.gui.jtable.renderers;

import java.awt.Component;

import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * If the value to be rendered is null or a NaN {@link Number}, then an empty {@link JPanel} is displayed with the same
 * background as the default (super calss) component is displayed for the cell.
 * 
 * @author Hank.Herr
 */
public class EmptyLabelOnNullOrNaNRenderer extends ForwardingTableCellRenderer
{
    public EmptyLabelOnNullOrNaNRenderer(final TableCellRenderer delegate)
    {
        super(delegate);
    }

    @Override
    public Component getTableCellRendererComponent(final JTable table,
                                                   final Object value,
                                                   final boolean isSelected,
                                                   final boolean hasFocus,
                                                   final int row,
                                                   final int column)
    {
        final Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if((value == null) || ((value instanceof Number) && (Double.isNaN(((Number)value).doubleValue()))))
        {
            final JPanel panel = new JPanel();
            panel.setBackground(c.getBackground());
            return panel;
        }
        else
        {
            return c;
        }
    }
}
