package ohd.hseb.hefs.utils.gui.jtable.renderers;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * {@link TableCellRenderer} which forwards calls to
 * {@link #getTableCellRendererComponent(JTable, Object, boolean, boolean, int, int)} to another
 * {@link TableCellRenderer} supplied upon creation.<br/>
 * You can override this class to create a {@link TableCellRenderer} which modifies the behavior of an existing one.
 * 
 * @author alexander.garbarino
 */
public class ForwardingTableCellRenderer implements TableCellRenderer
{
    private final TableCellRenderer _delegate;

    public ForwardingTableCellRenderer(TableCellRenderer delegate)
    {
        _delegate = delegate;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value,
                                                   boolean isSelected,
                                                   boolean hasFocus,
                                                   int row,
                                                   int column)
    {
        return _delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

}
