package ohd.hseb.hefs.utils.gui.jtable.renderers;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

/**
 * This renderer is useful for displaying icons in a table cell. The cell values are {@link JLabel}. The only reason
 * this is needed is to set the background color of a row to be that which is appropriate for a selected row. Hence, the
 * renderer component displays the JLabel value with a background determined using a {@link DefaultTableCellRenderer}.
 * The returned component for each cell is a different component (it does not share a component like some renderers).
 * 
 * @author herrhd
 */
public class JLabelTableCellRenderer extends DefaultTableCellRenderer
{
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(final JTable table,
                                                   final Object value,
                                                   final boolean isSelected,
                                                   final boolean hasFocus,
                                                   final int row,
                                                   final int column)
    {
        if(value == null)
        {
            final JLabel badLabel = new JLabel("GARBAGE");
            badLabel.setBackground(Color.red);
            return badLabel;
        }

        final Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        final JLabel label = (JLabel)value;

//XXX THIS CODE WILL ALLOW FOR AN ANIMATED ICON TO BE DISPLAYED, but it has a habit of stopping the updates eventually.  Thus, its commented out.
//        if(label.getIcon() instanceof ImageIcon)
//        {
//            ((ImageIcon)label.getIcon()).setImageObserver(new ImageObserver()
//            {
//                @Override
//                public boolean imageUpdate(final Image img,
//                                           final int infoflags,
//                                           final int x,
//                                           final int y,
//                                           final int width,
//                                           final int height)
//                {
//                    if((infoflags & (FRAMEBITS | ALLBITS)) != 0)
//                    {
//                        final Rectangle rect = table.getCellRect(row, column, false);
//                        table.repaint(rect);
//                    }
//                    return (infoflags & (ALLBITS | ABORT)) == 0;
//                }
//            });
//        }

        label.setOpaque(true); //This is needed to draw the background color correctly
        final Color color = result.getBackground();
        label.setBackground(color);
        return label;
    }
}
