package ohd.hseb.hefs.utils.gui.jtable.renderers;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;

import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

/**
 * Wraps the default editors provided by {@link JTable}, making them use a single click to edit and select all upon
 * clicking.
 * 
 * @author hank.herr
 */
public class SingleClickSelectAllJTableDefaultEditor implements TableCellEditor
{
    private final TableCellEditor _baseEditor;

    /**
     * @param baseTable Used to call getDefaultEditor for the column class.
     * @param columnClass The class for which a default editor is to be acquired.
     */
    public SingleClickSelectAllJTableDefaultEditor(JTable baseTable, Class<?> columnClass)
    {
        _baseEditor = baseTable.getDefaultEditor(columnClass);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column)
    {
        final Component c = _baseEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        if(c instanceof JTextField)
        {
            c.addFocusListener(new FocusListener()
            {

                @Override
                public void focusGained(FocusEvent e)
                {
                    if(c instanceof JTextField)
                    {
                        ((JTextField)c).selectAll();
                    }
                }

                @Override
                public void focusLost(FocusEvent e)
                {
                }
            });
        }
        return c;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l)
    {
        _baseEditor.addCellEditorListener(l);
    }

    @Override
    public void cancelCellEditing()
    {
        _baseEditor.cancelCellEditing();
    }

    @Override
    public Object getCellEditorValue()
    {
        return _baseEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent)
    {
        if(anEvent instanceof MouseEvent)
        {
            return ((MouseEvent)anEvent).getClickCount() >= 1;
        }
        return _baseEditor.isCellEditable(anEvent);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l)
    {
        _baseEditor.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent)
    {
        return _baseEditor.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing()
    {
        return _baseEditor.stopCellEditing();
    }

}
