/*
 * Created on Mar 7, 2007 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.hefs.utils.gui.listpanels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import ohd.hseb.hefs.utils.gui.tools.HSwingFactory;
import ohd.hseb.hefs.utils.gui.tools.SwingTools;

/**
 * Same as a JListPanel, but it provides a panel of checkboxes. To get the items that are checked, call the method
 * getSelectedListData(). To determine the source of the popup menu item click, call getClickedOnCheckBox.
 * 
 * @author hank
 */
public class CheckableListPanel extends JPanel implements ActionListener, MouseListener
{
    private static final long serialVersionUID = 1L;

    private Font _listFont;
    private Font _borderFont;

    /**
     * List containing all Strings.
     */
    private List<String> _allListData;

    /**
     * List of only those that are highlighted.
     */
    private List<String> _highlightedListData;

    /**
     * List of JCheckBoxes, one for each entry in _allListData.
     */
    private List<JCheckBox> _checkBoxList;

    private JScrollPane _listSP;

    /**
     * The JCheckBox currently selected by the mouse.
     */
    private JCheckBox _clickedOnCheckBox;

    /**
     * Menu to popup, if desired, when a checkbox is right clicked.
     */
    private JPopupMenu _popupMenu;

    /**
     * If true, then the _popupMenu will open when a right click occurs on a check box.
     */
    private final boolean _includePopupMenu;

    /**
     * The owner of this CheckableListPanel.
     */
    private final ListPanelOwner _owner;

    /**
     * Overall color of panel background.
     */
    private final Color _bgColor;

    /**
     * Background color for non-highlighted check boxes.
     */
    private final Color _listItemBGColor = Color.WHITE;

    /**
     * Background color for highlighted check boxes.
     */
    private final Color _highlightBGColor = Color.LIGHT_GRAY;

    /**
     * If true, then NONE is to be at the top of the list at all times. If false, then NONE will only be included when
     * there are no list items.
     */
    private final boolean _includeNone;

    /**
     * The text to put in the titled border for this panel.
     */
    private final String _title;

    /**
     * The tool tip to assign to each check box.
     */
    private String _checkBoxToolTipText;

    /**
     * If true, then the list, when updated, will always be sorted.
     */
    private boolean _sortListForDisplay;

    /**
     * @param title The border title for this panel.
     * @parma listData The list data, which must be a List of Strings. The list will be sorted alphabetically upon
     *        construction. This list is copied by the class.
     * @param bgColor The background color for the containing panels.
     * @param listItemBGsystemSetting The system setting giving the background color for list items.
     * @param highlightBGSystemSetting The system setting giving the background color for highlighted list items.
     * @param includeNone True if NONE is to be part of the list. If NONE is not found in the list, it will be added at
     *            the top.
     * @param includePopupMenu True if a popup menu can be created and the owner provides it.
     * @param owner The owner, which is called whenever a selection is made from the list.
     */
    public CheckableListPanel(final String title,
                              final List<String> listData,
                              final Color bgColor,
                              final String listItemBGSystemSetting,
                              final String highlightBGSystemSetting,
                              final boolean includeNone,
                              final boolean includePopupMenu,
                              final ListPanelOwner owner)
    {
        _checkBoxToolTipText = "";
        _title = title;
        _bgColor = bgColor;
        _owner = owner;
        _includeNone = includeNone;
        _includePopupMenu = includePopupMenu;
        _allListData = new ArrayList<String>();
        _highlightedListData = new ArrayList<String>();
        _sortListForDisplay = true;
        createDisplay();
        setAllListData(listData);
        createPopupMenu();
    }

    /**
     * Create the display.
     */
    private void createDisplay()
    {
        //Create the scroll pane and imbedded panel. 
        final JPanel innerPanel = new JPanel(new GridBagLayout());
        innerPanel.setBackground(Color.WHITE);
        _listSP = new JScrollPane(innerPanel);
        _listSP.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        _listSP.setWheelScrollingEnabled(true);

        //This is the interior panel
        final JPanel panel = new JPanel(new GridBagLayout());

        //Fill in the interior panel.
        GridBagConstraints constraints;
        Insets theinsets = new Insets(5, 5, 5, 5);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          theinsets,
                                                          0,
                                                          0);
        panel.add(_listSP, constraints);
        final TitledBorder tb = new TitledBorder(new LineBorder(Color.GRAY), _title);
        tb.setTitleFont(_borderFont);
        panel.setBorder(tb);

        //Put the interior panel within this panel so that I can have some insets.
        setLayout(new GridBagLayout());
        theinsets = new Insets(2, 2, 2, 2);
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.WEST,
                                                          GridBagConstraints.BOTH,
                                                          theinsets,
                                                          0,
                                                          0);
        add(panel, constraints);

        //Set the backgrounds.
        if(_bgColor != null)
        {
            panel.setBackground(_bgColor);
            setBackground(_bgColor);
        }
    }

    /**
     * Called from the constructor to acquire the popup menu associated with this list, if there is one (see
     * _includePopupMenu).
     */
    private void createPopupMenu()
    {
        if(!_includePopupMenu)
        {
            _popupMenu = null;
            return;
        }
        _popupMenu = _owner.getListPanelPopupMenu(this);
        int i;
        for(i = 0; i < _popupMenu.getComponents().length; i++)
        {
            if(_popupMenu.getComponents()[i] instanceof JMenuItem)
            {
                ((JMenuItem)_popupMenu.getComponents()[i]).addActionListener(this);
            }
        }
    }

    /**
     * Highlight check boxes with data, based on contents of _highlightedListData.
     */
    private void highlightListedItems()
    {
        int i;
        if(_checkBoxList == null)
        {
            return;
        }
        for(i = 0; i < _checkBoxList.size(); i++)
        {
            final JCheckBox box = _checkBoxList.get(i);

            //Set the background color.
            if(_highlightedListData.indexOf(_allListData.get(i)) >= 0)
            {
                box.setBackground(_highlightBGColor);
            }
            else
            {
                box.setBackground(_listItemBGColor);
            }
        }

    }

    /**
     * Builds a panel containing check boxes for each _allListData item. Put those checkboxes into _checkBoxList, so
     * that the indices match up with _allListData. Puts the panel inside of the _listSP viewport view.
     */
    private void updateListedItems()
    {
        //innerPanel is the viewport view within _listSP.
        final JPanel innerPanel = (JPanel)(_listSP.getViewport().getView());
        innerPanel.removeAll();
        innerPanel.repaint();

        //holderPanel will hold the checkboxes in a grid bag layout.
        final JPanel holderPanel = new JPanel(new GridLayout(_allListData.size(), 1));
        holderPanel.setBackground(Color.WHITE);

        //Clear the checkbox list.
        _checkBoxList = new ArrayList<JCheckBox>();

        //Height is the total of all check boxes.  Width is the largest of all check boxes.
        int holderPanelHeight = 0;
        int holderPanelWidth = 0;

        int i;
        for(i = 0; i < _allListData.size(); i++)
        {
            //Add to the holder panel.
            final JCheckBox box = HSwingFactory.createJCheckBox(_allListData.get(i), _listFont, true);
            box.addMouseListener(this);
            if(box.getText().equalsIgnoreCase(JListPanel.NONE_STR))
            {
                box.setSelected(false);
                box.setEnabled(false);
            }
            box.setToolTipText(_checkBoxToolTipText);

            //Add the box to the list.
            _checkBoxList.add(box);

            //Add to the holder panel height and set the width if needed.
            holderPanelHeight += (int)box.getPreferredSize().getHeight();
            if(box.getPreferredSize().getWidth() > holderPanelWidth)
            {
                holderPanelWidth = (int)box.getPreferredSize().getWidth();
            }

            holderPanel.add(box);
        }

        //Highlight locations in the list as needed.
        highlightListedItems();

        //Set the preferred size and add holder to inner panel.
        GridBagConstraints constraints;
        final Insets theinsets = new Insets(0, 0, 0, 0);
        holderPanel.setPreferredSize(new Dimension(holderPanelWidth, holderPanelHeight));
        constraints = SwingTools.returnGridBagConstraints(0,
                                                          0,
                                                          1,
                                                          1,
                                                          1,
                                                          1,
                                                          GridBagConstraints.NORTHWEST,
                                                          GridBagConstraints.HORIZONTAL,
                                                          theinsets,
                                                          0,
                                                          0);
        innerPanel.add(holderPanel, constraints);
    }

    /**
     * Sets the selected state for all checkboxes that are enabled.
     * 
     * @param b The new state (true for checked; false for unchecked).
     */
    public void setSelectedStateForAllCheckBoxes(final boolean b)
    {
        int i;
        for(i = 0; i < _checkBoxList.size(); i++)
        {
            _checkBoxList.get(i).setSelected(b);
        }
    }

    /**
     * Returns the checkbox clicked on by the mouse. Useful when a pop-up menu is associated with this component.
     * 
     * @return JCheckBox being right-clicked on.
     */
    public JCheckBox getClickedOnCheckBox()
    {
        return _clickedOnCheckBox;
    }

    public void setSortListForDisplay(final boolean b)
    {
        _sortListForDisplay = b;
    }

    @SuppressWarnings("unchecked")
    public void setAllListData(final List allData)
    {
        _allListData = new ArrayList<String>();

        if((allData == null) || (allData.size() == 0))
        {
            _allListData.add(JListPanel.NONE_STR);
        }
        else
        {
            _allListData.addAll(allData);
            if(_sortListForDisplay)
            {
                Collections.sort(_allListData);
            }
            if(_includeNone)
            {
                _allListData.add(0, JListPanel.NONE_STR);
            }
        }

        updateListedItems();
    }

    /**
     * Sets the data that is to be highlighted within the list.
     * 
     * @param data List of Strings, matching components of _allListData.
     */
    @SuppressWarnings("unchecked")
    public void setHighlightedListData(final List data)
    {
        _highlightedListData = new ArrayList<String>();
        if(data != null)
        {
            _highlightedListData.addAll(data);
        }

        highlightListedItems();
    }

    /**
     * Turns the checkbox on for all passed in locations.
     * 
     * @param data List of Strings.
     */
    public void setListDataToChecked(final List data)
    {
        int i;
        int index = -1;
        for(i = 0; i < data.size(); i++)
        {
            index = _allListData.indexOf(data.get(i));
            if(index >= 0)
            {
                _checkBoxList.get(index).setSelected(true);
            }
        }
    }

    /**
     * @return Returns the list data making up the entire list.
     */
    public List getListData()
    {
        return _allListData;
    }

    /**
     * @return Returns the items in the list that are checked.
     */
    @SuppressWarnings("unchecked")
    public List<String> getSelectedListData()
    {
        int i;
        final List<String> results = new ArrayList<String>();
        for(i = 0; i < _checkBoxList.size(); i++)
        {
            if(_checkBoxList.get(i).isSelected())
            {
                results.add(_allListData.get(i));
            }
        }
        return results;
    }

    public void setCheckBoxToolTipText(final String checkBoxToolTipText)
    {
        _checkBoxToolTipText = checkBoxToolTipText;
    }

    @Override
    public void mouseClicked(final MouseEvent arg0)
    {
    }

    @Override
    public void mouseEntered(final MouseEvent arg0)
    {
        final JCheckBox box = (JCheckBox)arg0.getSource();
        final Font newFont = _listFont.deriveFont(Font.BOLD);
        box.setFont(newFont);
    }

    @Override
    public void mouseExited(final MouseEvent arg0)
    {
        final JCheckBox box = (JCheckBox)arg0.getSource();
        box.setFont(_listFont);
    }

    @Override
    public void mousePressed(final MouseEvent arg0)
    {
        if((arg0.getButton() != MouseEvent.BUTTON1) && (_popupMenu != null) && (arg0.isPopupTrigger()))
        {
            _clickedOnCheckBox = (JCheckBox)arg0.getSource();
            _popupMenu.show(this, (arg0.getX()) + _clickedOnCheckBox.getLocation().x, (arg0.getY())
                + _clickedOnCheckBox.getLocation().y);
        }
    }

    @Override
    public void mouseReleased(final MouseEvent arg0)
    {
        if((arg0.getButton() != MouseEvent.BUTTON1) && (_popupMenu != null) && (arg0.isPopupTrigger()))
        {
            _popupMenu.show(this, arg0.getX(), arg0.getY());
        }
    }

    @Override
    public void actionPerformed(final ActionEvent arg0)
    {
        _owner.listPanelPopupMenuItemSelected(this, ((JMenuItem)arg0.getSource()).getText());
    }

}
