/*
 * Created on Mar 7, 2007 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.hefs.utils.gui.listpanels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

/**
 * Wrapper on DefaultListCellRenderer; it turns the background to a color if the specified cell corresponds to a
 * location that has data.
 * 
 * @author hank
 */
public class JListPanelCellRenderer extends DefaultListCellRenderer
{
    private static final long serialVersionUID = 1L;
    final static String CLASSNAME = "JListPanelCellRenderer";

    public final static Color DEFAULT_LIST_ITEM_BG_COLOR = Color.WHITE;
    public final static Color DEFAULT_LIST_ITEM_SELECTED_BG_COLOR = Color.GREEN;

    /**
     * The list of items to highlight, by name.
     */
    private final List<String> _listItemsHighlighted;

    /**
     * The color for highlighted items.
     */
    private Color _highlightBGColor;

    /**
     * The color for non-highlighted items.
     */
    private Color _listItemBGColor;

    /**
     * The panel that this renderer is attached to.
     */
    private final JListPanel _panelBeingRendered;

    /**
     * Text added to components (JLabel) that are "highlighted". Default value is "".
     */
    private String _highlightedPrefixText;

    /**
     * Text added to components (JLabel) that are not "highlighted". Default value is "".
     */
    private String _notHighlightedPrefixText;
    /**
     * The color for the locations with available data within the list. This is used by several classes.
     */
    public final static String TOK_GENERAL_LIST_AVAILABLE_COLOR = "GeneralListItemHighlightedColor";
    /**
     * The color for locations in the list that have no available data. This is used by several classes.
     */
    public final static String TOK_GENERAL_LIST_NOT_AVAILABLE_COLOR = "GeneralListItemColor";

    /**
     * @param panel The panel to which this renderer is attached.
     * @param listItemsHighlighted List of String (MUST BE Strings!)
     * @param listItemBGColor BG color for non-highlighted
     * @param highlightBGColor BG color for highlighted.
     */
    public JListPanelCellRenderer(final JListPanel panel, final List<String> listItemsHighlighted)
    {
        _panelBeingRendered = panel;
        _listItemsHighlighted = listItemsHighlighted;
        _highlightedPrefixText = "";
        _notHighlightedPrefixText = "";
        this.loadColors("", "");
    }

    /**
     * @param panel The panel to which this renderer is attached.
     * @param listItemsHighlighted List of String (MUST BE Strings!)
     * @param listItemBGColor BG color for non-highlighted
     * @param highlightBGColor BG color for highlighted.
     */
    @SuppressWarnings("unchecked")
    public JListPanelCellRenderer(final JListPanel panel,
                                  final List listItemsHighlighted,
                                  final String listItemBGSystemSetting,
                                  final String highlightBGSystemSetting)
    {
        _panelBeingRendered = panel;
        _listItemsHighlighted = listItemsHighlighted;
        _highlightedPrefixText = "";
        _notHighlightedPrefixText = "";
        this.loadColors(listItemBGSystemSetting, highlightBGSystemSetting);
    }

    private void loadColors(final String listItemBGSystemSetting, final String listItemSelectedBGSystemSetting)
    {
        _listItemBGColor = DEFAULT_LIST_ITEM_BG_COLOR;
        _highlightBGColor = DEFAULT_LIST_ITEM_SELECTED_BG_COLOR;
    }

    /**
     * Override DefaultListCellRenderer.
     */
    @Override
    public Component getListCellRendererComponent(final JList list,
                                                  final Object value,
                                                  final int index,
                                                  final boolean isSelected,
                                                  final boolean cellHasFocus)
    {
        final Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

        //This assumes the comp is a JLabel!
        if(_panelBeingRendered != null)
        {
            if(_panelBeingRendered.getIndexOfItemMouseIsOver() == index)
            {
                final Font newFont = ((JLabel)comp).getFont().deriveFont(Font.BOLD);
                ((JLabel)comp).setFont(newFont);
            }
        }

        //Deal with the prefix
        if(!((String)value).equalsIgnoreCase(JListPanel.NONE_STR))
        {
            if((_listItemsHighlighted == null) || (_listItemsHighlighted.indexOf(value) < 0))
            {
                ((JLabel)comp).setText(_notHighlightedPrefixText + ((JLabel)comp).getText());
            }
            else
            {
                ((JLabel)comp).setText(_highlightedPrefixText + ((JLabel)comp).getText());
            }
        }

        //Deal with the background color.
        if(_listItemsHighlighted == null)
        {
            return comp;
        }
        if((_listItemsHighlighted.indexOf(value) >= 0) && (!isSelected))
        {
            comp.setBackground(_highlightBGColor);
        }
        else if(!isSelected)
        {
            comp.setBackground(_listItemBGColor);
        }
        return comp;
    }

    public void setHighlightedPrefixText(final String str)
    {
        this._highlightedPrefixText = str;
    }

    public void setNotHightlightedPrefixText(final String str)
    {
        this._notHighlightedPrefixText = str;
    }

    public JListPanel getPanelBeingRendered()
    {
        return this._panelBeingRendered;
    }

}
