/*
 * Created on May 18, 2007
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package ohd.hseb.hefs.utils.gui.listpanels;

import javax.swing.JPopupMenu;

/**
 * This interface must be implemented by any class that intends to use a JListPanel.
 * As JListPanel is designed to allow for one GUI class to include several, the JListPanel
 * itself is always included as the first argument to any method, so that the implementing
 * class knows what JListPanel instance is calling the method.
 * @author hank
 */
public interface ListPanelOwner 
{
    /**
     * Called when an item is selected.
     * @param obj the caller JListPanel
     */
    public void listItemSelected(Object obj);

    /**
     * Called to acquire the popup menu if the _includePopupMenu attribute of JListPanel is true.
     * This pops up on a non-left click of the JList.
     * @param obj the caller JListPanel
     */
    public JPopupMenu getListPanelPopupMenu(Object obj);
    
    /**
     * Called whenever a popup menu item is selected.
     * @param obj the caller JListPanel
     * @param menuItemName The JMenuItem name, acquired by doing a getSource().getName() on the 
     * action event.
     */
    public void listPanelPopupMenuItemSelected(Object obj, String menuItemName);
    
    /**
     * Called whenever a list item is to be focused upon.  Usually, this is only via a popup menu,
     * so that its up to the implementer to call this method as needed.  However, to allow for 
     * flexibility, it is being included in the interface.
     * @param obj
     * @param item
     */
    public void listItemFocusedUpon(Object obj, String item);
}
