package ohd.hseb.hefs.utils.gui.mydoggy;

import info.clearthought.layout.TableLayout;

import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDialog;
import javax.swing.WindowConstants;

import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.plaf.ui.ResourceManager;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.ToFrontWindowFocusListener;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.WindowTransparencyListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/**
 * Hank: I only removed debug statements.
 * 
 * @author Angelo De Caro (angelo.decaro@gmail.com)
 * @author Hank Herr
 */
public class OHDMyDoggyContentDialog extends JDialog
{
    private static final long serialVersionUID = 1L;
    protected Content content;
    protected ContentUI contentUI;

    public OHDMyDoggyContentDialog(ResourceManager resourceManager,
                                   Content content,
                                   ContentUI contentUI,
                                   Frame parentFrame,
                                   Rectangle inBounds) throws HeadlessException
    {
        super(resourceManager.getBoolean("dialog.owner.enabled", true) ? parentFrame : null, false);

        this.content = content;
        this.contentUI = contentUI;

        // Setup title and component
        Component component = content.getComponent();
        component.setPreferredSize(component.getSize());

        setTitle(content.getTitle());
        getContentPane().setLayout(new TableLayout(new double[][]{{-1}, {-1}}));
        getContentPane().add(component, "0,0,FULL,FULL");

        // Init Listener
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        addWindowListener(new ContentDialogWindowAdapter());
        if(parentFrame == null)
            addWindowFocusListener(new ToFrontWindowFocusListener(this));

        addComponentListener(new ContentDialogComponentAdapter());

        if(resourceManager.getTransparencyManager().isServiceAvailable())
        {
            WindowTransparencyListener windowTransparencyListener = new WindowTransparencyListener(resourceManager.getTransparencyManager(),
                                                                                                   contentUI,
                                                                                                   this);
            addWindowListener(windowTransparencyListener);
            addWindowFocusListener(windowTransparencyListener);
        }

        // Setup bounds
        Rectangle detachedBounds = SwingUtil.validateBounds(contentUI.getDetachedBounds());
        if(detachedBounds != null)
        {
            setBounds(detachedBounds);
        }
        else
        {
            if(inBounds != null)
            {
                setBounds(inBounds);
            }
            else
            {
                if(parentFrame != null)
                {
                    Point location = parentFrame.getLocation();
                    location.translate(5, 5);
                    setLocation(location);
                }
                else
                {
                    SwingUtil.centrePositionOnScreen(this);
                }
            }
        }
    }

    @Override
    public void dispose()
    {
        super.dispose();

        content = null;
        contentUI = null;
    }

    protected class ContentDialogWindowAdapter extends WindowAdapter
    {
        @Override
        public void windowClosing(WindowEvent event)
        {
            content.setDetached(false);
        }
    }

    protected class ContentDialogComponentAdapter extends ComponentAdapter
    {

        @Override
        public void componentResized(ComponentEvent e)
        {
            if(isActive() && isVisible())
            {
                contentUI.setDetachedBounds(getBounds());
            }
        }

        @Override
        public void componentMoved(ComponentEvent e)
        {
            if(isActive() && isVisible())
            {
                contentUI.setDetachedBounds(getBounds());
            }
        }

    }
}
