package ohd.hseb.hefs.utils.gui.mydoggy;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Map;

import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentDialog;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentFrame;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/**
 * This is part of the massive subclassing necessary to get rid of the debug statements in {@link ContentDialog}. This
 * is changed so that it uses {@link OHDMyDoggyContentDialog}.
 * 
 * @author Angelo De Caro (angelo.decaro@gmail.com)
 * @author Hank Herr
 */
public abstract class OHDMyDoggyContentManagerUI<T extends ContentUI> extends MyDoggyContentManagerUI
{
    protected Map<Content, T> contentUIMap;

    @SuppressWarnings("unchecked")
    public OHDMyDoggyContentManagerUI()
    {
        contentManagerUIListeners = new EventListenerList();
        this.closeable = this.detachable = this.minimizable = true;
        this.contentUIMap = new Hashtable<Content, T>();
    }

    @Override
    public T getContentUI(final Content content)
    {
        return contentUIMap.get(content);
    }

    protected class ContentUIListener implements PropertyChangeListener
    {

        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final ContentUI contentUI = (ContentUI)evt.getSource();

            if(contentUI.getContent().isDetached())
            {
                if("detachedBounds".equals(evt.getPropertyName()))
                {
                    final Window window = SwingUtilities.windowForComponent(contentUI.getContent().getComponent());
                    window.setBounds((Rectangle)evt.getNewValue());
                }
                else if("addToTaskBar".equals(evt.getPropertyName()))
                {
                    final Content content = contentUI.getContent();
                    final Window oldWindow = SwingUtilities.windowForComponent(contentUI.getContent().getComponent());
                    final Frame parentFrame = (toolWindowManager.getWindowAnchestor() instanceof Frame) ? (Frame)toolWindowManager.getWindowAnchestor() : null;
                    final Component focusOwner = oldWindow.getFocusOwner();

                    // Init new window
                    Window dialog;
                    if((Boolean)evt.getNewValue())
                    {
                        dialog = new ContentFrame(resourceManager,
                                                  content,
                                                  contentUI,
                                                  parentFrame,
                                                  oldWindow.getBounds());
                    }
                    else
                    {
                        dialog = new OHDMyDoggyContentDialog(resourceManager,
                                                             content,
                                                             contentUI,
                                                             parentFrame,
                                                             oldWindow.getBounds());
                    }

                    dialog.setBounds(oldWindow.getBounds());
                    dialog.addWindowFocusListener(new ContentDialogFocusListener(content));
                    dialog.toFront();

                    // Dispose old
                    oldWindow.setVisible(false);
                    oldWindow.dispose();

                    // Show new
                    dialog.setVisible(true);

                    if(focusOwner != null)
                        SwingUtil.requestFocus(focusOwner);
                }
            }
        }
    }
}
