package ohd.hseb.hefs.utils.gui.mydoggy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.ContentManagerUIListener;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.MultiSplitConstraint;
import org.noos.xing.mydoggy.MultiSplitContentManagerUI;
import org.noos.xing.mydoggy.MultiSplitContentUI;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentFrame;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockablePanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.JTabbedContentPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitTabbedContentContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneEvent;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneListener;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyMultiSplitContentUI;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContent;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.content.action.NextContentAction;
import org.noos.xing.mydoggy.plaf.ui.content.action.PreviousContentAction;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/**
 * This class must use the {@link OHDMyDoggyContentDialog} in order to not display annoying debug messages when an
 * undocked panel is moved or resized. Unfortunately, due to how the class is designed, it necessitates a complete copy
 * of the base class. This leads to other issues when eventually force all five of the special OHDMyDoggy classes to be
 * written.
 * 
 * @author Angelo De Caro (angelo.decaro@gmail.com)
 * @author Hank Herr (using GraphGenContentDialog in order to avoid stupid debug print statements in ContentDialog).
 */
@SuppressWarnings("unchecked")
public class OHDMyDoggyMultiSplitContentManagerUI extends OHDMyDoggyContentManagerUI<MultiSplitContentUI> implements
MultiSplitContentManagerUI, PlafContentManagerUI, PropertyChangeListener
{
    protected MultiSplitContainer multiSplitContainer;
    protected boolean focusValueAdj = false;

    protected TabLayout tabLayout;
    protected TabPlacement tabPlacement;

    protected JPopupMenu popupMenu;
    protected Component componentInFocusRequest;

    protected FocusOwnerPropertyChangeListener focusOwnerPropertyChangeListener;

    public OHDMyDoggyMultiSplitContentManagerUI()
    {
        setContentManagerUI(this);

        this.tabPlacement = TabPlacement.TOP;
        this.tabLayout = TabLayout.SCROLL;
    }

    @Override
    public void setTabPlacement(final TabPlacement tabPlacement)
    {
        if(tabPlacement == null || tabPlacement == getTabPlacement())
            return;

        final TabPlacement old = this.tabPlacement;
        this.tabPlacement = tabPlacement;

        multiSplitContainer.setTabPlacement(tabPlacement);

        fireContentManagerUIProperty("tabPlacement", old, tabPlacement);
    }

    @Override
    public TabPlacement getTabPlacement()
    {
        return tabPlacement;
    }

    @Override
    public void setTabLayout(final TabLayout tabLayout)
    {
        if(tabLayout == null || tabLayout == getTabLayout())
            return;

        final TabLayout old = this.tabLayout;
        this.tabLayout = tabLayout;

        multiSplitContainer.setTabLayout(tabLayout);

        fireContentManagerUIProperty("tabLayout", old, tabLayout);
    }

    @Override
    public TabLayout getTabLayout()
    {
        return tabLayout;
    }

    @Override
    public boolean isShowAlwaysTab()
    {
        return multiSplitContainer.isUseAlwaysContentWrapper();
    }

    @Override
    public void setShowAlwaysTab(final boolean showAlwaysTab)
    {
        if(isShowAlwaysTab() == showAlwaysTab)
            return;

        final boolean old = isShowAlwaysTab();
        multiSplitContainer.setUseAlwaysContentWrapper(showAlwaysTab);

        fireContentManagerUIProperty("showAlwaysTab", old, showAlwaysTab);
    }

    @Override
    public PlafContentManagerUI install(final ContentManagerUI oldContentManagerUI, final ToolWindowManager manager)
    {
        // Init managers
        this.toolWindowManager = (MyDoggyToolWindowManager)manager;
        this.contentManager = manager.getContentManager();
        this.resourceManager = toolWindowManager.getResourceManager();

        if(oldContentManagerUI != null)
        {
            // Import properties from the old ContentManagerUI
            this.closeable = oldContentManagerUI.isCloseable();
            this.detachable = oldContentManagerUI.isDetachable();
            this.minimizable = oldContentManagerUI.isMinimizable();
        }
        // Import properties from the ContentManager
        setPopupMenu(contentManager.getPopupMenu());

        // Init Components
        initComponents();

        // Init listeners
        initListeners();

        // Set the main content with the multiSplitContainer
        toolWindowManager.setMainContent(multiSplitContainer);

        // Import contents
        lastSelected = null;
        Content selectedContent = null;

        contentValueAdjusting = true;
        for(final Content content: contentManager.getContents())
        {
            if(content.isSelected())
                selectedContent = content;
            addContent((PlafContent)content);
        }
        contentValueAdjusting = false;

        if(oldContentManagerUI != null)
        {
            if(resourceManager.getBoolean("ContentManagerUI.ContentManagerUiListener.import", false))
            {
                // Import listeners from the old ContentManagerUI
                for(final ContentManagerUIListener listener: oldContentManagerUI.getContentManagerUiListener())
                {
                    oldContentManagerUI.removeContentManagerUIListener(listener);
                    addContentManagerUIListener(listener);
                }
            }
        }

        // Now you can consider this manager installed
        this.installed = true;

        // Select the content selected on the previous ContentManagerUI
        if(oldContentManagerUI != null)
        {
            final Content selectedContent1 = selectedContent;
            SwingUtilities.invokeLater(new Runnable()
            {
                @Override
                public void run()
                {
                    if(selectedContent1 != null)
                        selectedContent1.setSelected(true);
                    else if(contentManager.getContentCount() > 0)
                    {
                        contentManager.getContent(0).setSelected(true);
                    }
                }
            });
        }

        return this;
    }

    @Override
    public void uninstall()
    {
        uninstalling = true;
        try
        {
            if(maximizedContent != null)
                maximizedContent.setMaximized(false);

            // Remove all contents
            contentValueAdjusting = true;
            for(final Content content: contentManager.getContents())
            {
                removeContent((PlafContent)content);
            }
            contentValueAdjusting = false;

            removeListeners();

            // Now you can consider this manager uninstalled
            this.installed = false;
        }
        finally
        {
            uninstalling = false;
        }
    }

    @Override
    public JPopupMenu getPopupMenu()
    {
        return popupMenu;
    }

    @Override
    public void setPopupMenu(final JPopupMenu popupMenu)
    {
        this.popupMenu = popupMenu;
    }

    @Override
    public synchronized void setSelected(final Content content, final boolean selected)
    {
        if(selected)
        {
            if(lastSelected != null)
                lastSelected.setSelected(false);

            if(content.isMinimized())
            {
                content.setMinimized(false);
                content.setSelected(true);
            }
            else if(content.isDetached())
            {
                // If the content is detached request the focus for owner window
                //EDR: add check if window != null
                final Window window = SwingUtilities.windowForComponent(content.getComponent());
                if(window != null)
                    SwingUtil.requestFocus(window);
            }
            else
            {
                // Restore an eventually maximized content
                final Content maximizedContent = getMaximizedContent();
                if(maximizedContent != null)
                    maximizedContent.setMaximized(false);

                // Choose the owner tab or check if the content is the main content
                for(final Component c: multiSplitContainer.getTabbedComponents())
                {
                    if(c instanceof JTabbedContentPane)
                    {
                        final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                        final int index = tabbedContentPane.indexOfContent(content);
                        if(index != -1)
                        {
                            valueAdjusting = true;

                            try
                            {
                                tabbedContentPane.setSelectedIndex(index);
                                if(!focusValueAdj)
                                    componentInFocusRequest = findAndRequestFocus(tabbedContentPane.getComponentAt(index));
                                else
                                {
                                    SwingUtilities.invokeLater(new Runnable()
                                    {
                                        @Override
                                        public void run()
                                        {
                                            componentInFocusRequest = findAndRequestFocus(tabbedContentPane.getComponentAt(index));
                                        }
                                    });
                                }
                                lastSelected = content;
                            }
                            finally
                            {
                                valueAdjusting = false;
                            }

                            return;
                        }
                    }
                    else if(c instanceof DockablePanel)
                    {
                        final DockablePanel dockablePanel = (DockablePanel)c;
                        if(dockablePanel.getDockable() == content)
                        {
                            valueAdjusting = true;

                            try
                            {
                                if(!focusValueAdj)
                                    componentInFocusRequest = findAndRequestFocus(dockablePanel);
                                else
                                {
                                    SwingUtilities.invokeLater(new Runnable()
                                    {
                                        @Override
                                        public void run()
                                        {
                                            componentInFocusRequest = findAndRequestFocus(dockablePanel);
                                        }
                                    });
                                }
                                lastSelected = content;
                            }
                            finally
                            {
                                valueAdjusting = false;
                            }

                            return;
                        }
                    }
                    if(c == content.getComponent())
                        return;
                }
// XXX (by the original writers; not Hank): should be resolved better...
//                throw new IllegalStateException("Invalid content ui state.");
            }
        }
        else
        {
            if(content == lastSelected)
                lastSelected = null;
        }
    }

    @Override
    public void updateUI()
    {
        multiSplitContainer.updateUI();
    }

    @Override
    public void selectNextContent(final Content content)
    {
        if(contentManager.getSelectedContent() == null)
        {
            if(contentManager.getContentCount() > 0)
                contentManager.getContent(0).setSelected(true);
        }
    }

    public Object getLayout()
    {
        return multiSplitContainer.getModel();
    }

    public void setLayout(final Object layout)
    {
        SwingUtilities.invokeLater(new Runnable()
        {
            @Override
            public void run()
            {
                multiSplitContainer.setModel((MultiSplitLayout.Node)layout);
            }
        });
    }

    protected void initComponents()
    {
        if(multiSplitContainer == null)
        {
            /// Init just once
            multiSplitContainer = new MultiSplitContainer(toolWindowManager);
            setupActions();
        }
    }

    protected void initListeners()
    {
        if(internalPropertyChangeSupport == null)
        {
            /// Init just once

            internalPropertyChangeSupport = new PropertyChangeSupport(this);
            internalPropertyChangeSupport.addPropertyChangeListener("component", new ComponentListener());
            internalPropertyChangeSupport.addPropertyChangeListener("disabledIcon", new DisabledIconListener());
            internalPropertyChangeSupport.addPropertyChangeListener("icon", new IconListener());
            internalPropertyChangeSupport.addPropertyChangeListener("mnemonic", new MnemonicListener());
            internalPropertyChangeSupport.addPropertyChangeListener("enabled", new EnabledListener());
            internalPropertyChangeSupport.addPropertyChangeListener("foreground", new ForegroundListener());
            internalPropertyChangeSupport.addPropertyChangeListener("title", new TitleListener());
            internalPropertyChangeSupport.addPropertyChangeListener("toolTipText", new ToolTipTextListener());
            final DetachedListener detachedListener = new DetachedListener();
            internalPropertyChangeSupport.addPropertyChangeListener("detached.dispose", detachedListener);
            internalPropertyChangeSupport.addPropertyChangeListener("detached", detachedListener);
            final MaximizedListener maximizedListener = new MaximizedListener();
            internalPropertyChangeSupport.addPropertyChangeListener("maximized.before", maximizedListener);
            internalPropertyChangeSupport.addPropertyChangeListener("maximized", maximizedListener);
            internalPropertyChangeSupport.addPropertyChangeListener("minimized", new MinimizedListener());

            contentUIListener = new ContentUIListener();
        }

        KeyboardFocusManager.getCurrentKeyboardFocusManager()
                            .addPropertyChangeListener("focusOwner",
                                                       focusOwnerPropertyChangeListener = new FocusOwnerPropertyChangeListener());

    }

    protected void removeListeners()
    {
        KeyboardFocusManager.getCurrentKeyboardFocusManager()
                            .removePropertyChangeListener("focusOwner", focusOwnerPropertyChangeListener);
    }

    protected void setupActions()
    {
//        SwingUtil.addKeyActionMapping(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT,
//                                      multiSplitContainer,
//                                      KeyStroke.getKeyStroke(39, InputEvent.ALT_MASK),
//                                      "nextContent",
//                                      new NextContentAction(toolWindowManager));
    	multiSplitContainer.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(39, InputEvent.ALT_DOWN_MASK),
                "nextContent");
        multiSplitContainer.getActionMap().put("nextContent",new NextContentAction(toolWindowManager));
    	//        SwingUtil.addKeyActionMapping(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT,
//                                      multiSplitContainer,
//                                      KeyStroke.getKeyStroke(37, InputEvent.ALT_MASK),
//                                      "previousContent",
//                                      new PreviousContentAction(toolWindowManager));
        multiSplitContainer.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(37, InputEvent.ALT_DOWN_MASK),
                "previousContent");
        multiSplitContainer.getActionMap().put("previousContent",new PreviousContentAction(toolWindowManager));
    }

    //XXX I cannot get rid of this warning and I will not change the second argument, as I don't know its impact.
    @Override
    protected Object addUIForContent(final Content content, final Object[] constraints)
    {
        MultiSplitContentUI contentUI = contentUIMap.get(content);
        if(contentUI == null)
        {
            contentUI = new MyDoggyMultiSplitContentUI(this, multiSplitContainer, content);
            contentUI.addPropertyChangeListener(contentUIListener);
            contentUI.setCloseable(closeable);
            contentUI.setDetachable(detachable);
            contentUI.setMinimizable(minimizable);

            contentUIMap.put(content, contentUI);
        }

        if(constraints != null && constraints.length > 0)
        {
            if(constraints[0] instanceof MultiSplitConstraint)
            {
                final MultiSplitConstraint constraint = (MultiSplitConstraint)constraints[0];
                multiSplitContainer.addDockable(content,
                                                content.getComponent(),
                                                constraint.getAggregationContent(),
                                                constraint.getAggregationIndexLocation(),
                                                constraint.getAggregationPosition());
            }
            else if(constraints[0] instanceof MultiSplitContainer.Constraint)
            {
                final MultiSplitContainer.Constraint constraint = (MultiSplitContainer.Constraint)constraints[0];
                multiSplitContainer.addDockable(content, content.getComponent(), constraint);
            }
            else
                multiSplitContainer.addDockable(content, content.getComponent(), null, -1, AggregationPosition.DEFAULT);
        }
        else
        {
            multiSplitContainer.addDockable(content, content.getComponent(), null, -1, AggregationPosition.DEFAULT);
        }

        SwingUtil.repaint(multiSplitContainer);

        return null;
    }

    @Override
    protected void removeUIForContent(final Content content)
    {
        // Remove component
        valueAdjusting = true;
        try
        {
            // Remove from multiSplitContainer
            multiSplitContainer.removeDockable(content);
        }
        finally
        {
            valueAdjusting = false;
        }
    }

    protected class ComponentListener implements PropertyChangeListener
    {
        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();

            if(content.isMinimized())
                return;

            if(content.isDetached())
            {
                final RootPaneContainer rootPaneContainer = (RootPaneContainer)SwingUtilities.windowForComponent(content.getComponent());
                final Container container = rootPaneContainer.getContentPane();
                container.removeAll();
                container.add((Component)evt.getNewValue());
            }
            else
            {
                for(final Component c: multiSplitContainer.getTabbedComponents())
                {
                    if(c instanceof JTabbedContentPane)
                    {
                        final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                        final int index = tabbedContentPane.indexOfContent(content);
                        if(index != -1)
                        {
                            tabbedContentPane.setComponentAt(index, (Component)evt.getNewValue());
                            return;
                        }
                    }
                    if(c == content.getComponent())
                    {
                        multiSplitContainer.setRootComponent((Component)evt.getNewValue());
                        return;
                    }
                }
                throw new IllegalStateException("Invalid content ui state.");
            }
        }
    }

    protected class DisabledIconListener implements PropertyChangeListener
    {
        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();

            if(content.isMinimized())
                return;

            if(!content.isDetached())
            {
                for(final Component c: multiSplitContainer.getTabbedComponents())
                {
                    if(c instanceof JTabbedContentPane)
                    {
                        final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                        final int index = tabbedContentPane.indexOfContent(content);
                        if(index != -1)
                        {
                            tabbedContentPane.setDisabledIconAt(index, (Icon)evt.getNewValue());
                            return;
                        }
                    }
                    if(c == content.getComponent())
                        return;
                }
                throw new IllegalStateException("Invalid content ui state.");
            }
        }
    }

    protected class IconListener implements PropertyChangeListener
    {
        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();

            if(content.isMinimized())
                return;

            if(!content.isDetached())
            {
                for(final Component c: multiSplitContainer.getTabbedComponents())
                {
                    if(c instanceof JTabbedContentPane)
                    {
                        final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                        final int index = tabbedContentPane.indexOfContent(content);
                        if(index != -1)
                        {
                            tabbedContentPane.setIconAt(index, (Icon)evt.getNewValue());
                            return;
                        }
                    }
                    if(c == content.getComponent())
                        return;
                }
                throw new IllegalStateException("Invalid content ui state.");
            }
        }
    }

    protected class MnemonicListener implements PropertyChangeListener
    {
        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();

            if(content.isMinimized())
                return;

            if(!content.isDetached())
            {
                for(final Component c: multiSplitContainer.getTabbedComponents())
                {
                    if(c instanceof JTabbedContentPane)
                    {
                        final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                        final int index = tabbedContentPane.indexOfContent(content);
                        if(index != -1)
                        {
                            tabbedContentPane.setMnemonicAt(index, (Integer)evt.getNewValue());
                            return;
                        }
                    }
                    else if(c instanceof DockablePanel)
                    {
                        final DockablePanel dockablePanel = (DockablePanel)c;
                        if(dockablePanel.getDockable() == content)
                            return;
                    }
                    if(c == content.getComponent())
                        return;
                }
                throw new IllegalStateException("Invalid content ui state.");
            }
        }
    }

    protected class EnabledListener implements PropertyChangeListener
    {
        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();

            if(content.isMinimized())
                return;

            if(content.isDetached())
            {
                final Window anchestor = SwingUtilities.windowForComponent(content.getComponent());
                anchestor.setEnabled((Boolean)evt.getNewValue());
            }
            else
            {
                for(final Component c: multiSplitContainer.getTabbedComponents())
                {
                    if(c instanceof JTabbedContentPane)
                    {
                        final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                        final int index = tabbedContentPane.indexOfContent(content);
                        if(index != -1)
                        {
                            tabbedContentPane.setEnabledAt(index, (Boolean)evt.getNewValue());
                            return;
                        }
                    }
                    if(c == content.getComponent())
                        return;
                }
                throw new IllegalStateException("Invalid content ui state.");
            }
        }
    }

    protected class ForegroundListener implements PropertyChangeListener
    {
        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();

            if(content.isMinimized())
                return;

            if(!content.isDetached())
            {
                for(final Component c: multiSplitContainer.getTabbedComponents())
                {
                    if(c instanceof JTabbedContentPane)
                    {
                        final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                        final int index = tabbedContentPane.indexOfContent(content);
                        if(index != -1)
                        {
                            tabbedContentPane.setForegroundAt(index, (Color)evt.getNewValue());
                            return;
                        }
                    }
                    if(c == content.getComponent())
                        return;
                }
                throw new IllegalStateException("Invalid content ui state.");
            }
        }
    }

    protected class TitleListener implements PropertyChangeListener
    {
        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();

            if(content.isMinimized())
                return;

            if(content.isDetached())
            {
                SwingUtil.setWindowTitle(content.getComponent(), (String)evt.getNewValue());
            }
            else
            {
                for(final Component c: multiSplitContainer.getTabbedComponents())
                {
                    if(c instanceof JTabbedContentPane)
                    {
                        final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                        final int index = tabbedContentPane.indexOfContent(content);
                        if(index != -1)
                        {
                            tabbedContentPane.setTitleAt(index, (String)evt.getNewValue());
                            return;
                        }
                    }
                    if(c == content.getComponent())
                        return;
                }
                throw new IllegalStateException("Invalid content ui state.");
            }
        }
    }

    protected class ToolTipTextListener implements PropertyChangeListener
    {
        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();

            if(content.isMinimized())
                return;

            if(!content.isDetached())
            {
                for(final Component c: multiSplitContainer.getTabbedComponents())
                {
                    if(c instanceof JTabbedContentPane)
                    {
                        final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                        final int index = tabbedContentPane.indexOfContent(content);
                        if(index != -1)
                        {
                            tabbedContentPane.setToolTipTextAt(index, (String)evt.getNewValue());
                            return;
                        }
                    }
                    if(c == content.getComponent())
                        return;
                }
                throw new IllegalStateException("Invalid content ui state.");
            }
        }
    }

    protected class MaximizedListener implements PropertyChangeListener
    {
        protected ByteArrayOutputStream tmpWorkspace;
        protected Component oldFucusOwner;
        protected boolean valudAdj;

        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            if(valudAdj)
                return;
            final Content content = (Content)evt.getSource();

            if("maximized.before".equals(evt.getPropertyName()))
            {
                if((Boolean)evt.getNewValue())
                {
                    if(tmpWorkspace != null)
                    {
                        // Restore...
                        multiSplitContainer.setMaximizedDockable(null);
                        valudAdj = true;
                        try
                        {
                            toolWindowManager.getPersistenceDelegate()
                                             .merge(new ByteArrayInputStream(tmpWorkspace.toByteArray()),
                                                    resourceManager.getObject(PersistenceDelegate.MergePolicy.class,
                                                                              PersistenceDelegate.MergePolicy.UNION));
                        }
                        finally
                        {
                            valudAdj = false;
                        }
                        tmpWorkspace = null;
                    }

                    // Save and clear the workspace
                    toolWindowManager.getPersistenceDelegate().save(tmpWorkspace = new ByteArrayOutputStream());
                    toolWindowManager.getToolWindowGroup().setVisible(false);

                    oldFucusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();

                    // Maximize
                    multiSplitContainer.setMaximizedDockable(content);

                    // Resotre the focus owner

                    maximizedContent = content;
                }
            }
            else
            {
                if(!(Boolean)evt.getNewValue())
                {
                    if(tmpWorkspace != null)
                    {
                        multiSplitContainer.setMaximizedDockable(null);
                        valudAdj = true;
                        try
                        {
                            toolWindowManager.getPersistenceDelegate()
                                             .merge(new ByteArrayInputStream(tmpWorkspace.toByteArray()),
                                                    resourceManager.getObject(PersistenceDelegate.MergePolicy.class,
                                                                              PersistenceDelegate.MergePolicy.UNION));
                        }
                        finally
                        {
                            valudAdj = false;
                        }
                        tmpWorkspace = null;
                        maximizedContent = null;

                        // Restore focus owner
                        if(oldFucusOwner != null)
                        {
                            SwingUtil.requestFocus(oldFucusOwner);
                            oldFucusOwner = null;
                        }
                    }
                }
            }
        }
    }

    protected class DetachedListener implements PropertyChangeListener
    {
        protected Frame parentFrame;
        protected Map<Content, MultiSplitDockableContainer.Constraint> detachedContentUIMap;

        public DetachedListener()
        {
            detachedContentUIMap = new HashMap<Content, MultiSplitDockableContainer.Constraint>();
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();

            if("detached.dispose".equals(evt.getPropertyName()))
            {
                final Window window = SwingUtilities.windowForComponent(content.getComponent());
                window.setVisible(false);
                window.dispose();
                detachedContentUIMap.remove(content);
            }
            else
            {
                if((Boolean)evt.getNewValue())
                {
                    valueAdjusting = true;
                    try
                    {
                        final ContentUI contentUI = getContentUI(content);

                        final Rectangle inBounds = multiSplitContainer.getBoundsRelativeToScreen(content);

                        // Remove from multiSpli and store constraint
                        detachedContentUIMap.put(content, multiSplitContainer.removeDockable(content));

                        // Setup dialog
                        final Frame parentFrame = (toolWindowManager.getWindowAnchestor() instanceof Frame) ? (Frame)toolWindowManager.getWindowAnchestor() : null;

                        Window dialog;
                        if(contentUI.isAddToTaskBarWhenDetached())
                        {
                            dialog = new ContentFrame(resourceManager, content, contentUI, parentFrame, inBounds);
                        }
                        else
                        {
                            dialog = new OHDMyDoggyContentDialog(resourceManager,
                                                                 content,
                                                                 contentUI,
                                                                 parentFrame,
                                                                 inBounds);
                        }
                        dialog.addWindowFocusListener(new ContentDialogFocusListener(content));
                        dialog.toFront();
                        dialog.setVisible(true);

                        componentInFocusRequest = findAndRequestFocus(dialog);
                    }
                    finally
                    {
                        valueAdjusting = false;
                    }
                }
                else
                {
                    final Window window = SwingUtilities.windowForComponent(content.getComponent());
                    window.setVisible(false);
                    window.dispose();

                    contentValueAdjusting = true;
                    try
                    {
                        addUIForContent(content, new Object[]{detachedContentUIMap.get(content)});
                        content.setSelected(true);

                        componentInFocusRequest = findAndRequestFocus(content.getComponent());
                    }
                    finally
                    {
                        contentValueAdjusting = false;
                        detachedContentUIMap.remove(content);
                    }
                }
            }
        }

    }

    protected class FocusOwnerPropertyChangeListener implements PropertyChangeListener
    {

        public FocusOwnerPropertyChangeListener()
        {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            if(!isContentManagerEnabled())
                return;

            if(componentInFocusRequest != null)
            {
                if(evt.getNewValue() == componentInFocusRequest)
                    componentInFocusRequest = null;
                else
                    return;
            }

            if(evt.getNewValue() != null)
            {
                if(SwingUtil.getParent((Component)evt.getNewValue(), "toolWindow.container.") != null)
                    return;

                Dockable newSelected = null;

                final JTabbedContentPane tabbedPane = SwingUtil.getParent((Component)evt.getNewValue(),
                                                                          JTabbedContentPane.class);
                if(tabbedPane == null)
                {
                    final DockablePanel dockablePanel = SwingUtil.getParent((Component)evt.getNewValue(),
                                                                            DockablePanel.class);
                    if(dockablePanel != null)
                        newSelected = dockablePanel.getDockable();
                }
                else
                    newSelected = (Dockable)tabbedPane.getSelectedContent();

                if(newSelected != null && !valueAdjusting && !contentValueAdjusting)
                {
                    if(newSelected == lastSelected)
                        return;

                    if(lastSelected != null)
                        lastSelected.setSelected(false);

                    focusValueAdj = true;
                    try
                    {
                        newSelected.setSelected(true);
                    }
                    finally
                    {
                        focusValueAdj = false;
                    }
                }
            }
        }
    }

    protected class MinimizedListener implements PropertyChangeListener
    {
        protected Map<Content, MultiSplitDockableContainer.Constraint> minimizedContentUIMap;

        public MinimizedListener()
        {
            minimizedContentUIMap = new HashMap<Content, MultiSplitDockableContainer.Constraint>();
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt)
        {
            final Content content = (Content)evt.getSource();
            if((Boolean)evt.getNewValue())
            {
                content.setSelected(false);
                content.setMaximized(false);

                DockableDescriptor descriptor = toolWindowManager.getDockableDescriptor(content.getId());
                if(descriptor == null)
                    descriptor = toolWindowManager.createDescriptor(content);

                // Remove content
                minimizedContentUIMap.put(content, multiSplitContainer.removeDockable(content));

                // Put on bar
                descriptor.setAvailable(true);
            }
            else
            {
                final DockableDescriptor descriptor = toolWindowManager.getDockableDescriptor(content.getId());

                // Remove from bar
                descriptor.setAvailable(false);

                contentValueAdjusting = true;
                try
                {
                    //EDR: Skip adding constraints they cause errors to occur
//                    addUIForContent(content, minimizedContentUIMap.get(content));
                    addUIForContent(content, (Object[])null);
                    content.setSelected(true);

                    componentInFocusRequest = findAndRequestFocus(content.getComponent());
                }
                finally
                {
                    contentValueAdjusting = false;
                    minimizedContentUIMap.remove(content);
                }
            }
        }

    }

    @SuppressWarnings("serial")
    protected class MultiSplitContainer extends MultiSplitTabbedContentContainer
    {
        protected Component oldRoot;
        protected DockablePanel oldParent;
        protected Dockable currentMaximizedDockable;

        public MultiSplitContainer(final MyDoggyToolWindowManager toolWindowManager)
        {
            super(toolWindowManager);
        }

        @Override
        public void setRootComponent(final Component component)
        {
            super.setRootComponent(component);
        }

        @Override
        protected Component forceWrapperForComponent(final Dockable dockable, final Component component)
        {
            final JTabbedContentPane tabbedContentPane = (JTabbedContentPane)super.forceWrapperForComponent(dockable,
                                                                                                            component);

            tabbedContentPane.setTabPlacement(tabPlacement.ordinal() + 1);
            tabbedContentPane.setTabLayoutPolicy(tabLayout.ordinal());
            tabbedContentPane.addChangeListener(new ChangeListener()
            {
                @Override
                public void stateChanged(final ChangeEvent e)
                {
                    if(!valueAdjusting && !contentValueAdjusting)
                    {
                        final Content newSelected = (Content)tabbedContentPane.getSelectedContent();
                        if(newSelected != null && !newSelected.isMinimized())
                        {
                            if(newSelected == lastSelected)
                                return;

                            if(lastSelected != null)
                                lastSelected.setSelected(false);

                            newSelected.setSelected(true);
                        }
                    }
                }
            });
            tabbedContentPane.addTabbedContentPaneListener(new TabbedContentPaneListener()
            {
                @Override
                public void tabbedContentPaneEventFired(final TabbedContentPaneEvent event)
                {
                    final Content content = event.getContent();
                    switch(event.getActionId())
                    {
                        case ON_CLOSE:
                            if(fireContentUIRemoving(getContentUI(content)))
                                contentManager.removeContent(content);
                            break;
                        case ON_DETACH:
                            content.setDetached(true);
                            fireContentUIDetached(getContentUI(content));
                            break;
                    }
                }
            });
            return tabbedContentPane;
        }

        @Override
        protected boolean isWrapRequest(final Dockable dockable, final Action action)
        {
            switch(action)
            {
                case ADD_DOCK:
                    if(getContentCount() == 0)
                    {
                        return useAlwaysContentWrapper;
                    }
                    else if(getContentCount() >= 1)
                    {
                        return (((MultiSplitContentUI)((Content)dockable).getContentUI()).isShowAlwaysTab());
                    }
                    return useAlwaysContentWrapper;
                case REMOVE_DOCK:
                    if(getContentCount() <= 1)
                    {
                        return useAlwaysContentWrapper;
                    }
                    else if(getContentCount() > 1)
                    {
                        return (((MultiSplitContentUI)((Content)dockable).getContentUI()).isShowAlwaysTab());
                    }
                    return useAlwaysContentWrapper;
            }
            return useAlwaysContentWrapper;
        }

        public void setMaximizedDockable(final Dockable dockable)
        {
            if(dockable == null)
            {
                if(oldRoot != null)
                {
                    oldParent.setComponent(currentMaximizedDockable.getComponent());
                    setRootComponent(oldRoot);

                    this.oldRoot = null;
                    this.oldParent = null;
                    this.currentMaximizedDockable = null;
                }
            }
            else
            {
                this.currentMaximizedDockable = dockable;
                this.oldRoot = getRootComponent();
                this.oldParent = (DockablePanel)dockable.getComponent().getParent();

                setRootComponent(forceWrapperForComponent(dockable, dockable.getComponent()));
            }
            SwingUtil.repaint(this);
        }

        public void setTabPlacement(final TabPlacement tabPlacement)
        {
            for(final Component c: multiSplitContainer.getTabbedComponents())
            {
                if(c instanceof JTabbedContentPane)
                {
                    final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                    tabbedContentPane.setTabPlacement(tabPlacement.ordinal() + 1);
                }
            }
        }

        public void setTabLayout(final TabLayout tabLayout)
        {
            for(final Component c: multiSplitContainer.getTabbedComponents())
            {
                if(c instanceof JTabbedContentPane)
                {
                    final JTabbedContentPane tabbedContentPane = ((JTabbedContentPane)c);
                    tabbedContentPane.setTabLayoutPolicy(tabLayout.ordinal());
                }
            }
        }

    }

}