package ohd.hseb.hefs.utils.gui.mydoggy;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import org.noos.common.context.Context;
import org.noos.common.element.ElementWriter;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManager;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.MultiSplitContentManagerUI;
import org.noos.xing.mydoggy.MultiSplitContentUI;
import org.noos.xing.mydoggy.TabbedContentManagerUI;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.persistence.xml.XMLPersistenceDelegate;
import org.noos.xing.mydoggy.plaf.persistence.xml.XMLWriter;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentDialog;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/**
 * Part of the massive MyDoggy subclassing necessary to remove some annoying debug lines that they have left in the
 * {@link ContentDialog} code. This is because I need it to use the {@link OHDMyDoggyMultiSplitContentManagerUI} for
 * casting for the persistence writer and parser.
 * 
 * @author hank.herr
 */
public class OHDXMLPersistenceDelegate extends XMLPersistenceDelegate
{
    public OHDXMLPersistenceDelegate(final MyDoggyToolWindowManager toolWindowManager)
    {
        super(toolWindowManager);
        this.masterElementParser = new OHDMasterElementParser();
        this.masterElementWriter = new OHDToolWindowManagerElementWriter(toolWindowManager);
    }

    public class OHDMasterElementParser extends MasterElementParser
    {

        public OHDMasterElementParser()
        {
            super();
        }

        @Override
        protected void populateParserMap()
        {
            super.populateParserMap();
            elementParserMap.put("MultiSplitContentManagerUI", new OHDMultiSplitContentManagerUIElementParser());
        }

    }

    public class OHDToolWindowManagerElementWriter extends ToolWindowManagerElementWriter
    {
        public OHDToolWindowManagerElementWriter(final ToolWindowManager manager)
        {
            super(manager);
        }

        @Override
        protected void populateWriterMap()
        {
            super.populateWriterMap();
            elementWriterMap.put(MultiSplitContentManagerUI.class, new OHDMultiSplitContentManagerUIEntityPWriter());
        }
    }

    public class OHDMultiSplitContentManagerUIEntityPWriter implements ElementWriter<XMLWriter>
    {

        @Override
        public void write(final XMLWriter writer, final Context context)
        {
            try
            {
                final MultiSplitContentManagerUI multiSplitContentManagerUI = (MultiSplitContentManagerUI)context.get(ContentManagerUI.class);

                final AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute(null,
                                        "closeable",
                                        null,
                                        null,
                                        String.valueOf(multiSplitContentManagerUI.isCloseable()));
                attributes.addAttribute(null,
                                        "detachable",
                                        null,
                                        null,
                                        String.valueOf(multiSplitContentManagerUI.isDetachable()));
                attributes.addAttribute(null,
                                        "minimizable",
                                        null,
                                        null,
                                        String.valueOf(multiSplitContentManagerUI.isMinimizable()));
                attributes.addAttribute(null,
                                        "showAlwaysTab",
                                        null,
                                        null,
                                        String.valueOf(multiSplitContentManagerUI.isShowAlwaysTab()));
                attributes.addAttribute(null, "tabLayout", null, null, multiSplitContentManagerUI.getTabLayout()
                                                                                                 .toString());
                attributes.addAttribute(null, "tabPlacement", null, null, multiSplitContentManagerUI.getTabPlacement()
                                                                                                    .toString());

                writer.startElement("MultiSplitContentManagerUI", attributes);

                writer.startElement("contents");
                for(final Content content: context.get(ContentManager.class).getContents())
                {
                    final MultiSplitContentUI contentUI = (MultiSplitContentUI)content.getContentUI();

                    final AttributesImpl contentUIAttributes = new AttributesImpl();
                    contentUIAttributes.addAttribute(null, "id", null, null, content.getId());
                    contentUIAttributes.addAttribute(null,
                                                     "showAlwaysTab",
                                                     null,
                                                     null,
                                                     String.valueOf(contentUI.isShowAlwaysTab()));

                    writer.dataElement("content", contentUIAttributes);
                }
                writer.endElement("contents");

                writer.startElement("layout");
                final OHDMyDoggyMultiSplitContentManagerUI splitContentManagerUI = (OHDMyDoggyMultiSplitContentManagerUI)multiSplitContentManagerUI;

                final ByteArrayOutputStream os = new ByteArrayOutputStream();
                final XMLEncoder encoder = new XMLEncoder(os);
                encoder.writeObject(splitContentManagerUI.getLayout());
                encoder.flush();
                encoder.close();

                final String model = os.toString();
                writer.cdata(model.substring(model.indexOf('\n')));
                writer.endElement("layout");

                writer.endElement("MultiSplitContentManagerUI");
            }
            catch(final SAXException e)
            {
                throw new RuntimeException(e);
            }

        }

    }

    public class OHDMultiSplitContentManagerUIElementParser extends ElementParserAdapter
    {

        @Override
        public boolean parse(final Element element, final Context context)
        {
            if(context.get(ToolWindowManager.class).getContentManager().getContentManagerUI() instanceof MultiSplitContentManagerUI)
            {
                final MultiSplitContentManagerUI managerUI = (MultiSplitContentManagerUI)context.get(ToolWindowManager.class)
                                                                                                .getContentManager()
                                                                                                .getContentManagerUI();

                managerUI.setCloseable(getBoolean(element, "closeable", true));
                managerUI.setDetachable(getBoolean(element, "detachable", false));
                managerUI.setMinimizable(getBoolean(element, "minimizable", false));
                managerUI.setShowAlwaysTab(getBoolean(element, "showAlwaysTab", false));
                managerUI.setTabLayout(TabbedContentManagerUI.TabLayout.valueOf(element.getAttribute("tabLayout")));
                managerUI.setTabPlacement(TabbedContentManagerUI.TabPlacement.valueOf(element.getAttribute("tabPlacement")));

                final ContentManager contentManager = context.get(ToolWindowManager.class).getContentManager();

                // Load contents
                final Element contents = getElement(element, "contents");
                if(contents != null)
                {
                    final NodeList contentUIElms = contents.getElementsByTagName("content");
                    for(int i = 0, size = contentUIElms.getLength(); i < size; i++)
                    {
                        final Element contentUIElm = (Element)contentUIElms.item(i);

                        final Content content = contentManager.getContent(contentUIElm.getAttribute("id"));
                        if(content != null)
                        {
                            final MultiSplitContentUI multiSplitContentUI = (MultiSplitContentUI)content.getContentUI();
                            multiSplitContentUI.setShowAlwaysTab(getBoolean(contentUIElm, "showAlwaysTab", true));
                        }
                    }
                }

                // Load layout
                final Element layout = getElement(element, "layout");
                final OHDMyDoggyMultiSplitContentManagerUI myDoggyMultiSplitContentManagerUI = (OHDMyDoggyMultiSplitContentManagerUI)managerUI;

                final String text = layout.getTextContent();
                XMLDecoder decoder = null;
                try
                {
                    decoder = new XMLDecoder(new ByteArrayInputStream(text.getBytes()));
                    myDoggyMultiSplitContentManagerUI.setLayout(decoder.readObject());
                }
                finally
                {
                    decoder.close();
                }
            }

            return false;
        }

    }
}
