package ohd.hseb.hefs.utils.gui.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractAction;

/**
 * This class wraps a given ActionListener inside of an action, so that ActionEvent's can be relayed from this Action to
 * the ActionListener. The ActionEvent, when passed to the ActionListener, will have a source specified in the
 * constructor to this class. Hence, you can create an action that will trigger an ActionListener as if a button had
 * been clicked, for example. This is useful for old code where there is not separate Action for each button or in cases
 * where you do not want to create that many Actions. In those cases, you can just create an ActionEventRelayer and
 * assign the relayer to a key stroke, for example.
 * 
 * @author hank.herr
 */
public class ActionEventRelayer extends AbstractAction
{
    private static final long serialVersionUID = 1L;
    final ActionListener _listener;
    final Object _source;

    public ActionEventRelayer(ActionListener listener, Object source)
    {
        _listener = listener;
        _source = source;
    }

    @Override
    public void actionPerformed(ActionEvent e)
    {
        e.setSource(_source);
        _listener.actionPerformed(e);
    }

}
