package ohd.hseb.hefs.utils.gui.tools;

import static com.google.common.collect.Sets.newHashSet;

import java.text.ParseException;
import java.util.Set;

import javax.swing.text.DefaultFormatter;

@SuppressWarnings("serial")
public class AllowSpecifiedValuesFormatter<T> extends DefaultFormatter
{
    private final Set<T> _allowedValues;

    public AllowSpecifiedValuesFormatter(Class<? extends T> valueClass, Iterable<T> allowedValues)
    {
        _allowedValues = newHashSet(allowedValues);

        setAllowsInvalid(false);
        setCommitsOnValidEdit(true);
        setOverwriteMode(false);
        setValueClass(valueClass);
    }

    public AllowSpecifiedValuesFormatter(Class<? extends T> valueClass, T... allowedValues)
    {
        _allowedValues = newHashSet(allowedValues);

        setAllowsInvalid(false);
        setCommitsOnValidEdit(true);
        setOverwriteMode(false);
        setValueClass(valueClass);
    }

    @Override
    public Object stringToValue(String string) throws ParseException
    {
        Object value = super.stringToValue(string);
        if(_allowedValues.contains(value))
        {
            return value;
        }
        else
        {
            throw new ParseException(string + " is not one of the allowed values.", 0);
        }
    }
}
