/*
 * Created on Oct 21, 2003 Filename : Author : Gautam Sood Last Revision Date : Oct 21, 2003
 */
package ohd.hseb.hefs.utils.gui.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

import ohd.hseb.hefs.utils.gui.components.BufferJPanel;

public class ComponentHelper
{

    public static void addPanelComponent(JPanel panel,
                                         Component component,
                                         int column,
                                         int row,
                                         int width,
                                         int height,
                                         int fill)
    {
        addComponent(panel, component, column, row, width, height, 0, 0, fill);
    }

    public static void addPanelComponent(JPanel panel,
                                         Component component,
                                         int column,
                                         int row,
                                         int width,
                                         int height,
                                         double weightx,
                                         double weighty,
                                         int fill)
    {
        addComponent(panel, component, column, row, width, height, weightx, weighty, fill);
    }

    public static void addPanelComponent(JPanel panel,
                                         Component component,
                                         GridBagConstraints gbc,
                                         int column,
                                         int row,
                                         int width,
                                         int height,
                                         int fill)
    {
        addComponent(panel, component, gbc, column, row, width, height, fill);
    }

    public static void addFrameComponent(Container frameContentPane,
                                         Component component,
                                         int column,
                                         int row,
                                         int width,
                                         int height,
                                         int fill)
    {
        addComponent(frameContentPane, component, column, row, width, height, 0, 0, fill);
    }

    public static void addFrameComponent(Container frameContentPane,
                                         Component component,
                                         int column,
                                         int row,
                                         int width,
                                         int height,
                                         double weightx,
                                         double weighty,
                                         int fill)
    {
        addComponent(frameContentPane, component, column, row, width, height, weightx, weighty, fill);
    }

    private static void addComponent(Container container,
                                     Component component,
                                     int column,
                                     int row,
                                     int width,
                                     int height,
                                     double weightx,
                                     double weighty,
                                     int fill)
    {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.fill = fill;

        setConstraints(gbConstraints, column, row, width, height, weightx, weighty);

        GridBagLayout layoutMgr = (GridBagLayout)container.getLayout();
        layoutMgr.setConstraints(component, gbConstraints);

        container.add(component);
    }

    private static void addComponent(Container container,
                                     Component component,
                                     GridBagConstraints constraints,
                                     int column,
                                     int row,
                                     int width,
                                     int height,
                                     int fill)
    {
        GridBagConstraints gbConstraints = constraints;
        gbConstraints.fill = fill;

        double weightx = gbConstraints.weightx;
        double weighty = gbConstraints.weighty;
        setConstraints(gbConstraints, column, row, width, height, weightx, weighty);

        GridBagLayout layoutMgr = (GridBagLayout)container.getLayout();
        layoutMgr.setConstraints(component, gbConstraints);

        container.add(component);
    }

    private static void setConstraints(GridBagConstraints gbConstraints,
                                       int column,
                                       int row,
                                       int width,
                                       int height,
                                       double weightx,
                                       double weighty)
    {
        gbConstraints.gridx = column;
        gbConstraints.gridy = row;
        gbConstraints.gridwidth = width;
        gbConstraints.gridheight = height;
        gbConstraints.weightx = weightx;
        gbConstraints.weighty = weighty;
    }

    /**
     * Reconstructs the panel removing any BufferJPanels.
     * 
     * @param panel
     * @return
     */
    public static JPanel removeEndingBufferJPanelIfAny(JPanel panel)
    {
        if(panel.getLayout() instanceof GridBagLayout)
        {
            int lastCompIndex = panel.getComponentCount() - 1;
            if(panel.getComponent(lastCompIndex) instanceof BufferJPanel)
            {
                panel.remove(lastCompIndex);
            }
        }
        return panel;
    }

    /**
     * @param component Component to which key stroke is added.
     * @param condition One of the constants JComponent.WHEN_FOCUSED, JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT,
     *            JComponent.WHEN_IN_FOCUSED_WINDOW.
     * @param stroke Key stroke to map
     * @param action Action to perform
     */
    public static void addKeyBinding(JComponent component, int condition, KeyStroke stroke, Action action)
    {
        String keyStrokeAndKey = stroke.toString();
        component.getInputMap(condition).put(stroke, keyStrokeAndKey);
        component.getActionMap().put(keyStrokeAndKey, action);
    }

    /**
     * Adds key binding to a specified source triggering the specified ActionListener, which may or may not be listening
     * to the source.
     * 
     * @param component The component to which the key binding will apply.
     * @param condition One of the constants JComponent.WHEN_FOCUSED, JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT,
     *            JComponent.WHEN_IN_FOCUSED_WINDOW.
     * @param stroke Key stroke to map.
     * @param actionListener The ActionListener to be triggered whenever the key is pressed.
     * @param source The source for the ActionEvent that gets passed to the ActionListener. This will typically be a
     *            component, such as a button, which this key event is to emulate.
     */
    public static void addKeyBinding(JComponent component,
                                     int condition,
                                     KeyStroke stroke,
                                     ActionListener actionListener,
                                     Object source)
    {
        String keyStrokeAndKey = stroke.toString();
        component.getInputMap(condition).put(stroke, keyStrokeAndKey);
        component.getActionMap().put(keyStrokeAndKey, new ActionEventRelayer(actionListener, source));
    };

    public static void makeTextFieldSelectAllOnFocusGained(final JTextField field)
    {
        field.addFocusListener(new FocusAdapter()
        {
            @Override
            public void focusGained(FocusEvent e)
            {
                field.selectAll();
            }
        });
    }
}
