package ohd.hseb.hefs.utils.gui.tools;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;

/**
 * Tools to assist in building and using cursors.
 * 
 * @author hank.herr
 */
public abstract class CursorTools
{

    /**
     * Assumes that the hotspot is the upper left corner, (0,0). I may need to create a version in the future with a
     * flexible hotspot. The size of the cursor is at least as large as what the best cursor size is, returned by
     * {@link Toolkit#getBestCursorSize(int, int)} (the tool kit is acquired via {@link Toolkit#getDefaultToolkit()}).
     * 
     * @param image Image to put in the cursor in the upper left corner.
     * @param cursorName The name of the cursor.
     * @return A cursor.
     */
    public static Cursor createCursorFromImage(final Image image, final String cursorName)
    {
        final Dimension baseCursorSize = Toolkit.getDefaultToolkit().getBestCursorSize(image.getWidth(null),
                                                                                       image.getHeight(null));
        if((baseCursorSize.getWidth() <= image.getWidth(null)) && (baseCursorSize.getHeight() <= image.getHeight(null)))
        {
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), cursorName);
        }
        return Toolkit.getDefaultToolkit().createCustomCursor(SwingTools.expandImageWithEmptySpace(image,
                                                                                                   baseCursorSize),
                                                              new Point(0, 0),
                                                              cursorName);
    }

}
