package ohd.hseb.hefs.utils.gui.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JDialog;

/**
 * @author alexander.garbarino
 * @param <T> this can be ignored - it ensures that any received {@link GenericDialogComponent}s extend
 *            {@link Component}
 */
@SuppressWarnings("serial")
public class GenericDialog<T extends Component & GenericDialogComponent> extends JDialog
{
    private final T _component;

    public GenericDialog(T component)
    {
        _component = component;

        this.setTitle(_component.getTitle());
        this.setLayout(new BorderLayout());
        this.add(component, BorderLayout.CENTER);
        this.setSize(component.getPreferredSize().width + 15, _component.getPreferredSize().height + 35);

        this.addWindowListener(new WindowAdapter()
        {
            @Override
            public void windowClosed(WindowEvent evt)
            {
                _component.windowClosed(evt);
            }
        });
    }
}
