package ohd.hseb.hefs.utils.gui.tools;

import java.awt.event.WindowEvent;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;

@SuppressWarnings("serial")
public abstract class GenericDialogPanel extends JPanel implements GenericDialogComponent
{
    private final Runnable _initializeGui = new Runnable()
    {
        @Override
        public void run()
        {
            initializeGui();
        }
    };

    public GenericDialogPanel()
    {
        SwingUtilities.invokeLater(_initializeGui);
    }

    @Override
    public void windowClosed(WindowEvent evt)
    {
    }

    protected GenericDialog getDialog()
    {
        return SwingTools.getParentOfClass(this, GenericDialog.class);
    }

    @Override
    public String getTitle()
    {
        return null;
    }

    protected abstract void initializeGui();
}
