package ohd.hseb.hefs.utils.gui.tools;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.swing.JDialog;
import javax.swing.JOptionPane;

/**
 * This defines an annotation that looks like "@GlobalDialogParent". It defines the component as one that can serve as a
 * parent for {@link JDialog} instances, such as those created by {@link JOptionPane}.  Call {@link SwingTools#getGlobalDialogParent(java.awt.Component)}
 * to find a parent that has this annotation.   
 * 
 * @author hank.herr
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface GlobalDialogParent
{
}