package ohd.hseb.hefs.utils.gui.tools;

import javax.swing.AbstractAction;

import ohd.hseb.hefs.utils.tools.IconTools;

/**
 * Wraps {@link AbstractAction} taking in an iconName and loading the icon using {@link IconTools#getHSEBIcon(String)}.
 * 
 * @author Hank.Herr
 */
@SuppressWarnings("serial")
public abstract class IconAction extends AbstractAction
{
    public IconAction(String iconName)
    {
        super(null, IconTools.getHSEBIcon(iconName));
    }

    public IconAction(String text, String iconName)
    {
        super(text, IconTools.getHSEBIcon(iconName));
    }
}
