package ohd.hseb.hefs.utils.gui.tools;

import java.util.List;

import javax.swing.JList;
import javax.swing.SwingUtilities;

import com.google.common.collect.Lists;

public abstract class JListUtilities
{

    /**
     * @return Indices of the values within the provided list, in order.
     */
    public static int[] getIndices(final JList list, final List values)
    {
        final List<Integer> indices = Lists.newArrayList();
        for(int index = 0; index < values.size(); index++)
        {
            final Object value = values.get(index);
            for(int i = 0; i < list.getModel().getSize(); i++)
            {
                if((value == list.getModel().getElementAt(i)) || (value.equals(list.getModel().getElementAt(i))))
                {
                    indices.add(i);
                    break;
                }
            }
        }

        final int[] results = new int[indices.size()];
        for(int i = 0; i < indices.size(); i++)
        {
            results[i] = indices.get(i);
        }
        return results;
    }

    /**
     * Select the items from the list specified by the values. This calls {@link JList#setSelectedIndices(int[])} after
     * calling {@link #getIndices(JList, List)} to acquire the int[].
     */
    public static void selectItems(final JList list, final List values)
    {
        final int[] indices = getIndices(list, values);
        list.setSelectedIndices(indices);
    }

    /**
     * Scross the scrollpane that contains the JList to the specified row.
     * 
     * @param list
     * @param row
     */
    public static void scrollToRow(final JList list, final int row)
    {
        SwingUtilities.invokeLater(new Runnable()
        {
            public void run()
            {
                list.scrollRectToVisible(list.getCellBounds(row, row));
            }
        });
    }

    /**
     * Selects a row and scrolls to it.
     * 
     * @param list The JList to affect.
     * @param row The row to select.
     */
    public static void selectRowAndScrollToIt(final JList list, final int row)
    {
        list.getSelectionModel().setSelectionInterval(row, row);
        scrollToRow(list, row);
    }
}
