package ohd.hseb.hefs.utils.gui.tools;

import java.awt.Component;
import java.util.ArrayList;

import javax.swing.JToolBar;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

/**
 * Used for creating tool bars. Can take components as well as {@link Supplier}s of components. Useful for if you want
 * to specify what to put in a {@link JToolBar}, but can't instantiate some of the components yet.<br>
 * Example:<br>
 * <code>
 * JToolBarBuilder bb = new JToolBarBuilder();<br>
 * bb.setFloatable(false);<br>
 * bb.add((Component)button);<br>
 * bb.add(JToolBarBuilder.FILLER);<br>
 * bb.add((Supplier&lt;Component&gt;)buttonSupplier);<br>
 * JToolBar b = bb.build();
 * </code>
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public class JToolBarBuilder extends ArrayList<Supplier<Component>>
{
    private boolean _floatable = true;

    public boolean add(Component comp)
    {
        this.add(this.size(), comp);
        return true;
    }

    public void add(int index, Component comp)
    {
        this.add(index, Suppliers.ofInstance(comp));
    }

    public JToolBarBuilder setFloatable(boolean floatable)
    {
        _floatable = floatable;
        return this;
    }

    public JToolBar build()
    {
        JToolBar bar = new JToolBar();
        for(Supplier<Component> supplier: this)
        {
            Component comp = supplier.get();
            if(comp == null)
            {
                bar.addSeparator();
            }
            else
            {
                bar.add(comp);
            }
        }
        bar.setFloatable(_floatable);
        return bar;
    }

    public static final Supplier<Component> SEPARATOR = Suppliers.ofInstance(null);

    public static final Supplier<Component> FILLER = new Supplier<Component>()
    {
        @Override
        public Component get()
        {
            return HSwingFactory.createFillerJPanel();
        }
    };

}
