package ohd.hseb.hefs.utils.gui.tools;

import ohd.hseb.hefs.utils.gui.jtable.GeneralRowSelectionNotice;
import ohd.hseb.hefs.utils.gui.jtable.GenericTable;

import com.google.common.eventbus.Subscribe;

/**
 * A {@link SelfListeningButton}. In addition it listens for {@link GeneralRowSelectionNotice}s to be fired from any bus
 * on which this is registered. For example, {@link GenericTable} first such notices when rows are selected. <br>
 * <br>
 * The {@link #_enableOnOneSelection} attributes controls if this button is enabled when only one item is selected. If
 * true, it does, if false it requires multiple items. The default is false and it can be set via
 * {@link #setAllowOneSelection(boolean)}.
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public abstract class MultiItemButton extends SelfListeningButton implements GeneralRowSelectionNotice.Subscriber
{
    public boolean _enableOnOneSelection = false;

    protected MultiItemButton()
    {
        super();
        setEnabled(false);
    }

    protected MultiItemButton(final String textOrIconName)
    {
        super(textOrIconName);
        setEnabled(false);
    }

    protected MultiItemButton(final String textOrIconName, final String toolTip)
    {
        super(textOrIconName, toolTip);
        setEnabled(false);
    }

    public void setEnableOnOneSelection(final boolean b)
    {
        _enableOnOneSelection = b;
    }

    @Override
    @Subscribe
    public void reactToTableRowSelection(final GeneralRowSelectionNotice evt)
    {
        if((evt.getSelectedRows() == null) || (evt.getSelectedRows().size() < 1))
        {
            setEnabled(false);
        }
        else if(!_enableOnOneSelection && evt.getSelectedRows().size() == 1)
        {
            setEnabled(false);
        }
        else
        {
            setEnabled(true);
        }

    }
}
