package ohd.hseb.hefs.utils.gui.tools;

import static com.google.common.collect.Lists.newArrayList;

import java.text.ParseException;
import java.util.List;

import javax.swing.JFormattedTextField.AbstractFormatter;
import javax.swing.text.DefaultFormatter;

/**
 * A formatter that takes a list of formatters, trying each in turn until one succeeds.
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public class OrCompositeFormatter extends DefaultFormatter
{
    private final List<AbstractFormatter> _components;

    public OrCompositeFormatter(Iterable<? extends AbstractFormatter> formatters)
    {
        setAllowsInvalid(true);
        setCommitsOnValidEdit(true);
        setOverwriteMode(false);
        _components = newArrayList(formatters);
    }

    public OrCompositeFormatter(AbstractFormatter... formatters)
    {
        setAllowsInvalid(true);
        setCommitsOnValidEdit(true);
        setOverwriteMode(false);
        _components = newArrayList(formatters);
    }

    @Override
    public String valueToString(Object value) throws ParseException
    {
        for(AbstractFormatter formatter: _components)
        {
            try
            {
                return formatter.valueToString(value);
            }
            catch(ParseException e)
            {
            }
        }
        throw new ParseException(value.toString() + " could not be converted.", 0);
    }

    @Override
    public Object stringToValue(String string) throws ParseException
    {
        for(AbstractFormatter formatter: _components)
        {
            try
            {
                return formatter.stringToValue(string);
            }
            catch(ParseException e)
            {
            }
        }
        throw new ParseException(string + " could not be formatted.", 0);
    }
}
