package ohd.hseb.hefs.utils.gui.tools;

import javax.swing.SpinnerNumberModel;

/**
 * As {@link SpinnerNumberModel}, but when the next step would go under/over the minimum/maximum, but not hit it
 * exactly, return the minimum/maximum instead of not moving.
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public class ReachBoundsSpinnerNumberModel extends SpinnerNumberModel
{
    public ReachBoundsSpinnerNumberModel(final Number value,
                                         final Comparable minimum,
                                         final Comparable maximum,
                                         final Number stepSize)
    {
        super(value, minimum, maximum, stepSize);
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object getNextValue()
    {
        Object next = super.getNextValue();
        if(next == null && ((Comparable<Object>)getMaximum()).compareTo(getValue()) > 0)
        {
            next = getMaximum();
        }
        return next;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object getPreviousValue()
    {
        Object previous = super.getPreviousValue();
        if(previous == null && ((Comparable<Object>)getMinimum()).compareTo(getValue()) < 0)
        {
            previous = getMinimum();
        }
        return previous;
    }
}
