/*
 * Created on Nov 6, 2014 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.hefs.utils.gui.tools;

import java.awt.Dimension;
import java.awt.Rectangle;

import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;

/**
 * {@link JPanel} that implements the {@link Scrollable} interface.
 * 
 * @author hank To change the template for this generated type comment go to Window&gt;Preferences&gt;Java&gt;Code
 *         Generation&gt;Code and Comments
 */
@SuppressWarnings("serial")
public class ScrollableJPanel extends JPanel implements Scrollable
{
    private boolean _verticallyScrollable = true;
    private boolean _horizontallyScrollable = true;

    /**
     * @param verticallyScrollable If true, then the panel will allow for scrolling vertically. That means
     *            {@link #getScrollableTracksViewportHeight()} will return false. If false, scrolling will not be
     *            allowed vertically, so that the method returns true.
     * @param horizontallyScrollable See verticallyScrollable description, but it applies to
     *            {@link #getScrollableTracksViewportWidth()}.
     */
    public ScrollableJPanel(boolean verticallyScrollable, boolean horizontallyScrollable)
    {
        _verticallyScrollable = verticallyScrollable;
        _horizontallyScrollable = horizontallyScrollable;
    }

    public Dimension getPreferredScrollableViewportSize()
    {
        return getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction)
    {
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction)
    {
        return ((orientation == SwingConstants.VERTICAL) ? visibleRect.height : visibleRect.width) - 10;
    }

    public boolean getScrollableTracksViewportWidth()
    {
        return !_horizontallyScrollable;
    }

    public boolean getScrollableTracksViewportHeight()
    {
        return !_verticallyScrollable;
    }
}
