package ohd.hseb.hefs.utils.gui.tools;

import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;

import ohd.hseb.hefs.utils.tools.IconTools;

@SuppressWarnings("serial")
public abstract class SelfListeningButton extends JButton implements ActionListener
{
    protected SelfListeningButton()
    {
        super();
        this.addActionListener(this);
    }

    /**
     * @param textOrIconName Do not include hefsIcons or the extension for icons to be automatically found in the
     *            hefsIcons nonsrc directory.
     */
    protected SelfListeningButton(final String textOrIconName)
    {
        this();
        final ImageIcon icon = IconTools.getHSEBIcon(textOrIconName);
        if(icon == null)
        {
            this.setText(textOrIconName);
        }
        else
        {
            this.setIcon(icon);
        }
    }

    /**
     * @param textOrIconName Do not include hefsIcons or the extension for icons to be automatically found in the
     *            hefsIcons nonsrc directory.
     */
    protected SelfListeningButton(final String textOrIconName, final String toolTip)
    {
        this(textOrIconName);
        this.setToolTipText(toolTip);
    }
}
