package ohd.hseb.hefs.utils.gui.tools;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

import ohd.hseb.hefs.utils.tools.IconTools;

/**
 * Implements {@link ActionListener} and provides an {@link #addRolloverShading()} method to manually force roll-over
 * shading if not done by default.
 * 
 * @author Hank.Herr
 */
@SuppressWarnings("serial")
public abstract class SelfListeningMenuItem extends JMenuItem implements ActionListener
{
    protected SelfListeningMenuItem()
    {
        super();
        this.addActionListener(this);
    }

    protected SelfListeningMenuItem(final String textOrIconName)
    {
        this();
        final ImageIcon icon = IconTools.getHSEBIcon(textOrIconName);
        if(icon == null)
        {
            this.setText(textOrIconName);
        }
        else
        {
            this.setIcon(icon);
        }
    }

    protected SelfListeningMenuItem(final String textOrIconName, final String toolTip)
    {
        this(textOrIconName);
        this.setToolTipText(toolTip);
    }

    /**
     * Adds a {@link MouseAdapter} to this menu item that will result in the menu item being shaded when rolled over.
     */
    public void addRolloverShading()
    {
        addMouseListener(new MouseAdapter()
        {
            @Override
            public void mouseEntered(final MouseEvent e)
            {
                setBackground(new Color(196, 196, 255));
            }

            @Override
            public void mouseExited(final MouseEvent e)
            {
                setBackground(Color.WHITE);
            }
        });
    }
}
