package ohd.hseb.hefs.utils.gui.tools;

import javax.swing.AbstractAction;

import ohd.hseb.hefs.utils.notify.collect.CollectionModifiedNotice;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;

/**
 * {@link AbstractAction} that makes itself enabled based on if there is only one item in the
 * {@link CollectionModifiedNotice} collection that it listens for. This needs to be registered to a
 * {@link CollectionModifiedNotice} processing {@link EventBus}.
 * 
 * @author Hank.Herr
 */
@SuppressWarnings("serial")
public abstract class SingleItemAction extends AbstractAction implements CollectionModifiedNotice.Subscriber
{
    @Override
    @Subscribe
    public void reactToCollectionModified(CollectionModifiedNotice evt)
    {
        setEnabled((evt.getCollection().size() == 1));
    }
}
