package ohd.hseb.hefs.utils.gui.tools;

import ohd.hseb.hefs.utils.gui.jtable.GeneralRowSelectionNotice;
import ohd.hseb.hefs.utils.gui.jtable.GenericTable;

import com.google.common.eventbus.Subscribe;

/**
 * As {@link SelfListeningButton}. It listens for {@link GeneralRowSelectionNotice} to be fired for it to react. It can
 * be tied into any table or list that generates such notices, including {@link GenericTable}.
 * 
 * @author alexander.garbarino
 */
@SuppressWarnings("serial")
public abstract class SingleItemButton extends SelfListeningButton implements GeneralRowSelectionNotice.Subscriber
{
    private boolean _enableOnFirstRowSelected = true;
    private boolean _enableOnLastRowSelected = true;

    protected SingleItemButton()
    {
        super();
        setEnabled(false);
    }

    protected SingleItemButton(final String textOrIconName)
    {
        super(textOrIconName);
        setEnabled(false);
    }

    protected SingleItemButton(final String textOrIconName, final String toolTip)
    {
        super(textOrIconName, toolTip);
        setEnabled(false);
    }

    public void setEnableOnFirstRowSelected(final boolean enableOnFirstRowSelected)
    {
        _enableOnFirstRowSelected = enableOnFirstRowSelected;
    }

    public void setEnableOnLastRowSelected(final boolean enableOnLastRowSelected)
    {
        _enableOnLastRowSelected = enableOnLastRowSelected;
    }

    @Override
    @Subscribe
    public void reactToTableRowSelection(final GeneralRowSelectionNotice evt)
    {
        if((evt.getSelectedRows() == null) || (evt.getSelectedRows().size() != 1))
        {
            setEnabled(false);
        }
        else if(!_enableOnFirstRowSelected && (evt.getSelectedModelRowIndices()[0] == 0))
        {
            setEnabled(false);
        }
        else if(!_enableOnLastRowSelected && (evt.getSelectedModelRowIndices()[0] == evt.getTotalRowCount() - 1))
        {
            setEnabled(false);
        }
        else
        {
            setEnabled(true);
        }

    }
}
