
package ohd.hseb.hefs.utils.gui.tools;

import java.awt.Dimension;
import java.awt.Point;


/////////////////////////////////////////////////////////////////////////////////////////////////
// WindowLocation Class
/////////////////////////////////////////////////////////////////////////////////////////////////
//
// This abstract class provides static methods to maintain the locations of windows that are
// to pop up in a graphical user interface.  This is particularly handy if the GUI is to spawn
// many other windows and you do not want every window to be displayed on top of each other.
// The size of the entire screen to position within is defined by the static variables MAX_POS_X
// and MAX_POS_Y.  The method getLocation(Dimension size) returns the Point on the screen where
// the window should be located, if the window has a size specified by the passed in Dimension.
//
/////////////////////////////////////////////////////////////////////////////////////////////////
//
//      Date            Person          Comment
//      ----------      ------------    ----------------------------------------------
//      2001-03-08      Hank Herr       First version completed (about a month ago).
//
/////////////////////////////////////////////////////////////////////////////////////////////////
//
//  STATIC VARS:
//
//    final  static int MOVE_ADJ  = 25;
//    public static int MAX_POS_X = 1200;
//    public static int MAX_POS_Y = 1000;
//    final  static int BASE_X    = 25;
//    final  static int BASE_Y    = 25;
//    static int CURRENT_X = 0;
//    static int CURRENT_Y = 0;
//
//  ATTRIBUTES:
//
//  
//  FUNCTIONS (in order of appearance):
//    public static Point getLocation()    
//    public static Point getLocation(Dimension size)
//    
/////////////////////////////////////////////////////////////////////////////////////////////////

public abstract class WindowLocation
{
    final static String CLASSNAME = "WindowLocation";

    final  static int MOVE_ADJ  = 25;
    final  static int BASE_X    = 25;
    final  static int BASE_Y    = 25;
    
    public static int MAX_POS_X = 1200;
    public static int MAX_POS_Y = 1000;
    
    public static int CURRENT_X = 0;
    public static int CURRENT_Y = 0;
    
    
    //Update the current new window position.
    public static Point getLocation()
    {
        WindowLocation.CURRENT_X += WindowLocation.MOVE_ADJ;
        WindowLocation.CURRENT_Y += WindowLocation.MOVE_ADJ;
        
        //reset position is necessary.
        if (WindowLocation.CURRENT_X > WindowLocation.MAX_POS_X)
            CURRENT_X = BASE_X;
            
        if (WindowLocation.CURRENT_Y > WindowLocation.MAX_POS_Y)
            CURRENT_Y = BASE_Y;
        
        return new Point(WindowLocation.CURRENT_X, WindowLocation.CURRENT_Y);
    }
    
    //Update the current new window position, using the size of the window to locate
    public static Point getLocation(Dimension size)
    {
        WindowLocation.CURRENT_X += WindowLocation.MOVE_ADJ;
        WindowLocation.CURRENT_Y += WindowLocation.MOVE_ADJ;
        
        //reset position is necessary.
        if (WindowLocation.CURRENT_X + size.width > WindowLocation.MAX_POS_X)
            CURRENT_X = BASE_X;
            
        if (WindowLocation.CURRENT_Y + size.height > WindowLocation.MAX_POS_Y)
            CURRENT_Y = BASE_Y;
        
        return new Point(WindowLocation.CURRENT_X, WindowLocation.CURRENT_Y);
    }
     
    
    /**
     * Undoes the last getLocation() call, adjusting the position back
     * one level
     */
    public static void undoGetLocation()
    {
        WindowLocation.CURRENT_X -= WindowLocation.MOVE_ADJ;
        WindowLocation.CURRENT_Y -= WindowLocation.MOVE_ADJ;
    }
}
