package ohd.hseb.hefs.utils.http;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class HTTPConductor
{

//    private static final Logger LOG = Logger.getLogger(HTTPConductor.class);
    URL _url = null;
    private String _serverName = null;

    /**
     * Opens an HTTP connection to the specified server.
     * 
     * @param serverName Name of server.
     * @throws IOException If connection fails.
     */
    public HTTPConductor(final String serverName) throws IOException
    {
        _serverName = serverName;
        establishConnection();
    }

    /**
     * Check if the HTTP connections is already established.
     * 
     * @return true if connection already exist false if not connection exist
     */
    private boolean isConnected()
    {
        if(_url != null)
        {
            return true;
        }
        else
        {
            return false;
        }
    }

    /**
     * Get a connection to the HTTP server.
     * 
     * @throws IOException if a connection can not be established
     */
    private void establishConnection() throws IOException
    {
//        LOG.debug("HTTPSConductor connecting to " + _serverName + "...");
        _url = new URL(_serverName);

//        LOG.debug("FTPConductor successfully connected to " + _serverName + "...");
    }

    /**
     * Close the HTTP connection to the server.
     */
    public void closeConnection()
    {
//        LOG.debug("FTPConductor closing connection...");
        if(_url != null)
        {
            _url = null;
        }
//        LOG.debug("FTPConductor connection closed.");
    }

    /**
     * This will not create any directories, so the target parent directory must exist.
     * 
     * @param localAbsolutePathName The full path name of file to put.
     * @param serverAbsolutePathName The full path name of where to place it.
     * @throws IOException
     */
    public void putFileOntoServer(final String localAbsolutePathName, final String serverAbsolutePathName) throws IOException
    {
        if(!isConnected())
        {
            throw new IOException("HTTP client is not connected.");
        }
        final String s = URLEncoder.encode("A Test string to send to a servlet", "UTF-8");

        try
        {

            final URL u = new URL("http://myhost/servlet");

            // Open the connection and prepare to POST
            final URLConnection uc = u.openConnection();
            uc.setDoOutput(true);
            uc.setDoInput(true);
            uc.setAllowUserInteraction(false);

            final DataOutputStream dstream = new DataOutputStream(uc.getOutputStream());

            // The POST line
            dstream.writeBytes(s);
            dstream.close();

            // Read Response
            final InputStream in = uc.getInputStream();
            int x;
            while((x = in.read()) != -1)
            {
                System.out.write(x);
            }
            in.close();

            final BufferedReader r = new BufferedReader(new InputStreamReader(in));
            final StringBuffer buf = new StringBuffer();
            String line;
            while((line = r.readLine()) != null)
            {
                buf.append(line);
            }

        }
        catch(final IOException e)
        {
            e.printStackTrace(); // should do real exception handling
        }

    }

    /**
     * @param localAbsolutePathName The full path name of where to place it. File.separator should be used to separate
     *            components.
     * @param serverAbsolutePathName The full path name of file to retrieve. File.separator can be used to separate
     *            components; it will be translated to '/' prior to use.
     * @throws IOException
     */
    public void getFileFromServer(final String localAbsolutePathName, String serverAbsolutePathName) throws IOException
    {
        if(!isConnected())
        {
            throw new IOException("HTTP client is not connected.");
        }
        URL url = null;
        InputStream is = null;
        FileOutputStream fos = null;

        //Change to standard '/' FTP directory separator.
        serverAbsolutePathName = serverAbsolutePathName.replaceAll("\\" + File.separator, "/");

        //Get the parent and file name on server to get.
        final int parentIndex = serverAbsolutePathName.lastIndexOf("/");
        String serverFileName = serverAbsolutePathName;
        if(parentIndex > 0)
        {
            serverFileName = serverAbsolutePathName.substring(parentIndex + 1);
        }
        //Check that file exist in server. Change to directory.
        try
        {
            url = new URL(_serverName + serverAbsolutePathName);
        }
        catch(final Exception e)
        {
            //LOG.debug("Unable to change to directory " + serverAbsolutePathName + " on FTP server.");
            throw new IOException("Directory " + serverAbsolutePathName
                + " does not appear to exist; cannot download the file " + serverFileName + " within it.");
        }
        try
        {
            //Attempt to retrieve the file.
            //LOG.debug("FTPConductor getting file " + serverFileName + " from server and placing it here: "
            //   + localAbsolutePathName + "...");
            is = url.openStream();
            fos = new FileOutputStream(localAbsolutePathName);
            int oneChar;
            while((oneChar = is.read()) != -1)
            {
                fos.write(oneChar);
            }
            //LOG.debug("FTPConductor done getting file.");
        }
        catch(final Exception e)
        {
            throw new IOException("Failed to get file from server: " + e.getMessage());
        }
        finally
        {
            if(is != null)
            {
                is.close();
            }
            if(fos != null)
            {
                fos.close();
            }
        }
    }
}
