/*
 * Created on Sep 20, 2007 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.hefs.utils.jobs;

/**
 * Listener to implement when a component needs to hear the results of a running GenericJob.
 * 
 * @author hank
 */
public interface JobListener
{

    /**
     * Called when the job fails. THIS SHOULD BE MADE synchronized BY ANY IMPLEMENTING CLASS TO ENSURE THAT ONLY ONE JOB
     * SUCCEEDS OR FAILS AT A TIME.
     * 
     * @param exc An Exception describing what failed.
     * @param theJob The GenericJob that failed.
     */
    public void processJobFailure(Exception exc, GenericJob theJob, boolean displayMessage);

    /**
     * Called when the job succeeds. THIS SHOULD BE MADE synchronized BY ANY IMPLEMENTING CLASS TO ENSURE THAT ONLY ONE
     * JOB SUCCEEDS OR FAILS AT A TIME.
     * 
     * @param The GenericJob that succeeded.
     */
    public void processSuccessfulJobCompletion(GenericJob theJob);

}
