package ohd.hseb.hefs.utils.jobs;

import java.io.Serializable;

/**
 * Collection of attributes used as a go between for a GenericJob and HJobMonitorDialog, informing the dialog of the
 * progress made so far.
 * 
 * @author hank.herr
 */
public class JobMonitorAttr implements Serializable
{
    private static final long serialVersionUID = -8094136094177007514L;

    /**
     * If true, then there is no known maximum progress.
     */
    protected boolean _indeterminate = false;

    /**
     * Maximum progress.
     */
    protected int _maximum = 100;

    /**
     * Minimum progress.
     */
    protected int _minimum = 0;

    /**
     * Progress counter.
     */
    protected int _progress = 0;

    /**
     * Displayed note.
     */
    protected String _note = "Waiting for job Progressing...";

    /**
     * Attributes of a sub-job.
     */
    protected JobMonitorAttr _childAttr = null;

    /**
     * Attributes of this JobMonitorAttr's parent.
     */
    protected JobMonitorAttr _parentAttr = null;

    public JobMonitorAttr()
    {
        super();
    }

    public JobMonitorAttr(final JobMonitorAttr parent)
    {
        super();
        _parentAttr = parent;
    }

    public JobMonitorAttr(final String note, final int progress, final int min, final int max)
    {
        super();

        _note = note;
        _progress = progress;
        _minimum = min;
        _maximum = max;
    }

    public JobMonitorAttr(final String note, boolean indeterminate)
    {
        super();

        _note = note;
        _indeterminate = indeterminate;
    }

    /**
     * Creates a new child JobMonitorAttr.
     * 
     * @return the newly created attributes.
     */
    public JobMonitorAttr newChild()
    {
        if(_childAttr != null)
        {
            return _childAttr.newChild();
        }
        _childAttr = new JobMonitorAttr(this);
        return _childAttr;
    }

    /**
     * Clears the lowest child JobMonitorAttr.
     */
    public void clearChild()
    {
        if(_childAttr != null)
        {
            if(_childAttr.getChild() != null)
            {
                _childAttr.clearChild();
            }
            else
            {
                _childAttr = null;
            }
        }
    }

    public void clearMyself()
    {
        if(_parentAttr != null)
        {
            _parentAttr.clearChild();
        }
    }

    public JobMonitorAttr getChild()
    {
        return _childAttr;
    }

    public JobMonitorAttr getDeepestChild()
    {
        if(_childAttr == null)
        {
            return this;
        }
        return _childAttr.getDeepestChild();
    }

    /**
     * Count the number of children.
     * 
     * @return number of children + 1
     */
    public int getDepth()
    {
        if(_childAttr != null)
        {
            return _childAttr.getDepth() + 1;
        }
        else
        {
            return 1;
        }
    }

    public int getMaximum()
    {
        return _maximum;
    }

    public int getMinimum()
    {
        return _minimum;
    }

    public String getNote()
    {
        return _note;
    }

    public int getProgress()
    {
        return _progress;
    }

    public void incrementProgress()
    {
        _progress++;
    }

    public boolean isIndeterminate()
    {
        return _indeterminate;
    }

    public void setIndeterminate(final boolean indeterminate)
    {
        this._indeterminate = indeterminate;
        if(isIndeterminate())
        {
            setMaximum(0);
            setMinimum(0);
        }
    }

    public void setMaximum(final int maximum)
    {
        this._maximum = maximum;

        if(_maximum == 0)
        {
            setMinimum(0);
        }
    }

    public void setMinimum(final int minimum)
    {
        this._minimum = minimum;
    }

    public void setNote(final String note)
    {
        this._note = note;
    }

    public void setProgress(final int progress)
    {
        this._progress = progress;
    }
}
