package ohd.hseb.hefs.utils.jtree;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DnDConstants;

import javax.swing.JTree;
import javax.swing.tree.TreeModel;

/**
 * A tree that facilitates dragging and dropping within the tree itself. When a drop request is made, the
 * {@link TreeDropTargetListener} passed into the constructor will be called. To use this tree, just create a listener
 * and a tree model and pass them into the constructor, and voila.
 * 
 * @author hank.herr
 */
public class DragAndDropJTree extends JTree implements Autoscroll
{
    private static final long serialVersionUID = 1L;
    private static int MARGIN = 12;

    /**
     * @param model The TreeModel for the tree.
     * @param listener The listener that will receive drop information when an item is dropped by copy or move.
     *            Presumably, it will modify the tree data accordingly based on the drop information.
     */
    public DragAndDropJTree(TreeModel model, TreeDropTargetListener listener)
    {
        super(model);
        new TreeDragSource(this, DnDConstants.ACTION_COPY_OR_MOVE);
        TreeDropTarget dropTarget = new TreeDropTarget(this);
        dropTarget.addListener(listener);
        this.setAutoscrolls(true);
    }

    @Override
    public void autoscroll(Point p)
    {
        int realrow = getRowForLocation(p.x, p.y);
        Rectangle outer = getBounds();
        realrow = (p.y + outer.y <= MARGIN ? realrow < 1 ? 0 : realrow - 1 : realrow < getRowCount() - 1 ? realrow + 1 : realrow);
        scrollRowToVisible(realrow);
    }

    @Override
    public Insets getAutoscrollInsets()
    {
        Rectangle outer = getBounds();
        Rectangle inner = getParent().getBounds();
        return new Insets(inner.y - outer.y + MARGIN, inner.x - outer.x + MARGIN, outer.height - inner.height - inner.y
            + outer.y + MARGIN, outer.width - inner.width - inner.x + outer.x + MARGIN);
    }
}
