/*
 * Created on Oct 18, 2011 To change the template for this generated file go to Window&gt;Preferences&gt;Java&gt;Code
 * Generation&gt;Code and Comments
 */
package ohd.hseb.hefs.utils.jtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class JTreeTools
{

    public static void expandAllNodes(final JTree jtree)
    {
        for(int i = 0; i < jtree.getRowCount(); i++)
        {
            jtree.expandRow(i);
        }
    }

    public static void collapseAllNodes(final JTree jtree)
    {
        for(int i = 0; i < jtree.getRowCount(); i++)
        {
            jtree.collapseRow(i);
        }
    }

    /**
     * Creates {@link DefaultMutableTreeNode} instances based on the provided {@link Map}, one node per key. If a key's
     * value is a map, it calls itself, recursively, to get a list of nodes to add under the key node. If the key's
     * value is a {@link Collection}, it adds one child node per item in the list under the key node. Otherwise, the
     * key's value is added as a child node under the key node. All key nodes and child nodes are created using
     * toString.
     * 
     * @param map
     * @return {@link List} of {@link DefaultMutableTreeNode} based on the provided {@link Map}. The keys and values in
     *         the map must be compatible with DefaultMutableTreeNode; e.g. Strings, numbers, etc.
     */
    public static List<DefaultMutableTreeNode> createTreeNodesFromMap(final Map map)
    {
        final List<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();

        for(final Object key: map.keySet())
        {
            final DefaultMutableTreeNode keyNode = new DefaultMutableTreeNode(key);
            nodes.add(keyNode);
            final Object value = map.get(key);

            //If the value is map, compute the list of nodes recursively and add them.
            if(value instanceof Map)
            {
                final List<DefaultMutableTreeNode> subNodes = createTreeNodesFromMap((Map)value);
                for(final DefaultMutableTreeNode subNode: subNodes)
                {
                    keyNode.add(subNode);
                }
            }
            //If the value is a collection, add each element of the collection as a node.
            else if(value instanceof Collection)
            {
                for(final Object element: ((Collection)value).toArray())
                {
                    keyNode.add(new DefaultMutableTreeNode(element));
                }
            }
            //Otherwise, just add the values toString as a node.
            else
            {
                keyNode.add(new DefaultMutableTreeNode(value));
            }
        }
        return nodes;
    }

    /**
     * @param topNodeName Name of the root node, passed into constructor of {@link DefaultMutableTreeNode}.
     * @param map The map; see {@link #createTreeNodesFromMap(Map)} for more information.
     * @return A {@link JTree} constructed based on output from {@link #createTreeNodesFromMap(Map)}.
     */
    public static JTree createTreeFromMap(final String topNodeName, final Map map)
    {
        final DefaultMutableTreeNode topNode = new DefaultMutableTreeNode(topNodeName);

        for(final DefaultMutableTreeNode node: createTreeNodesFromMap(map))
        {
            topNode.add(node);
        }
        return new JTree(topNode);
    }

    /**
     * @return True if path2 is descended (below) path 1.
     * @author santhosh kumar T - santhosh@in.fiorano.com. See this website:
     *         http://www.jroller.com/santhosh/entry/retaining_jtree_expansion_state.
     */
    public static boolean isDescendant(TreePath path1, final TreePath path2)
    {
        int count1 = path1.getPathCount();
        final int count2 = path2.getPathCount();
        if(count1 <= count2)
            return false;
        while(count1 != count2)
        {
            path1 = path1.getParentPath();
            count1--;
        }
        return path1.equals(path2);
    }

    /**
     * @param row The row to check.
     * @return String specifying the rows that are expanded beneath the element corresponding to the provided row.
     * @author santhosh kumar T - santhosh@in.fiorano.com. See this website:
     *         http://www.jroller.com/santhosh/entry/retaining_jtree_expansion_state.
     */
    public static String getExpansionState(final JTree tree, final int row)
    {
        final TreePath rowPath = tree.getPathForRow(row);
        final StringBuffer buf = new StringBuffer();
        final int rowCount = tree.getRowCount();
        for(int i = row; i < rowCount; i++)
        {
            final TreePath path = tree.getPathForRow(i);
            if(i == row || isDescendant(path, rowPath))
            {
                if(tree.isExpanded(path))
                {
                    buf.append("," + String.valueOf(i - row));
                }
            }
            else
            {
                break;
            }
        }
        return buf.toString();
    }

    /**
     * @param tree
     * @param row
     * @param expansionState The return of {@link #getExpansionState(JTree, int)}.
     * @author santhosh kumar T - santhosh@in.fiorano.com. See this website:
     *         http://www.jroller.com/santhosh/entry/retaining_jtree_expansion_state.
     */
    public static void restoreExpanstionState(final JTree tree, final int row, final String expansionState)
    {
        final StringTokenizer stok = new StringTokenizer(expansionState, ",");
        while(stok.hasMoreTokens())
        {
            final int token = row + Integer.parseInt(stok.nextToken());
            tree.expandRow(token);
        }
    }

}
